/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.attacher;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.attacher.OpenJ9VirtualMachine;
import com.ibm.tools.attach.attacher.OpenJ9VirtualMachineDescriptor;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachPermission;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import openj9.internal.tools.attach.target.Advertisement;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.CommonDirectory;
import openj9.internal.tools.attach.target.IPC;
import openj9.internal.tools.attach.target.TargetDirectory;

public class OpenJ9AttachProvider
extends AttachProvider {
    @Override
    public OpenJ9VirtualMachine attachVirtualMachine(String string) throws AttachNotSupportedException, IOException {
        OpenJ9AttachProvider.checkAttachSecurity();
        try {
            OpenJ9VirtualMachine openJ9VirtualMachine = new OpenJ9VirtualMachine(this, string);
            IPC.logMessage((String)("Attach target id: " + string));
            openJ9VirtualMachine.attachTarget();
            return openJ9VirtualMachine;
        }
        catch (NullPointerException nullPointerException) {
            AttachNotSupportedException attachNotSupportedException = new AttachNotSupportedException(Msg.getString((String)"K0554"));
            attachNotSupportedException.initCause(nullPointerException);
            throw attachNotSupportedException;
        }
    }

    @Override
    public OpenJ9VirtualMachine attachVirtualMachine(VirtualMachineDescriptor virtualMachineDescriptor) throws AttachNotSupportedException, IOException {
        OpenJ9AttachProvider.checkAttachSecurity();
        if (!(virtualMachineDescriptor.provider() instanceof OpenJ9AttachProvider)) {
            throw new AttachNotSupportedException(Msg.getString((String)"K0543"));
        }
        OpenJ9VirtualMachine openJ9VirtualMachine = new OpenJ9VirtualMachine(this, virtualMachineDescriptor.id());
        openJ9VirtualMachine.attachTarget();
        return openJ9VirtualMachine;
    }

    @Override
    public List<VirtualMachineDescriptor> listVirtualMachines() {
        List list = null;
        PrivilegedExceptionAction<List> privilegedExceptionAction = () -> this.listVirtualMachinesImp();
        try {
            list = AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VirtualMachineDescriptor> listVirtualMachinesImp() {
        AttachHandler.waitForAttachApiInitialization();
        File file = CommonDirectory.getCommonDirFileObject();
        ArrayList<VirtualMachineDescriptor> arrayList = new ArrayList<VirtualMachineDescriptor>();
        if (null == file) {
            IPC.logMessage((String)"listVirtualMachines() error getting common directory");
            return null;
        }
        if (!file.exists()) {
            IPC.logMessage((String)("listVirtualMachines() common directory is absent, expected " + file.getAbsolutePath()));
            return arrayList;
        }
        if (!file.isDirectory()) {
            IPC.logMessage((String)("listVirtualMachines() common directory is mis-configured for " + file.getAbsolutePath()));
            return null;
        }
        try {
            CommonDirectory.obtainControllerLock((String)"OpenJ9AttachProvider.listVirtualMachinesImp");
        }
        catch (IOException iOException) {
            IPC.logMessage((String)"listVirtualMachines() IOError on controller lock : ", (String)iOException.toString());
            return arrayList;
        }
        try {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                ArrayList<VirtualMachineDescriptor> arrayList2 = arrayList;
                return arrayList2;
            }
            long l = IPC.getUid();
            for (File file2 : fileArray) {
                if (!file2.isDirectory() || !CommonDirectory.isFileOwnedByUid((File)file2, (long)l)) continue;
                boolean bl = true;
                File file3 = new File(file2, Advertisement.getFilename());
                long l2 = 0L;
                if (file3.exists()) {
                    OpenJ9VirtualMachineDescriptor openJ9VirtualMachineDescriptor = OpenJ9VirtualMachineDescriptor.fromAdvertisement(this, file3);
                    if (null != openJ9VirtualMachineDescriptor) {
                        long l3 = openJ9VirtualMachineDescriptor.getProcessId();
                        l2 = openJ9VirtualMachineDescriptor.getUid();
                        if (0L == l3 || IPC.processExists((long)l3)) {
                            arrayList.add(openJ9VirtualMachineDescriptor);
                            bl = false;
                        }
                    }
                    if (l != 0L && 0L == l2) {
                        l2 = CommonDirectory.getFileOwner((String)file3.getAbsolutePath());
                    }
                }
                if (!bl || l != 0L && l2 != l) continue;
                IPC.logMessage((String)"listVirtualMachines() removing stale directory : ", (String)file2.getName());
                TargetDirectory.deleteTargetDirectory((String)file2.getName());
            }
        }
        finally {
            CommonDirectory.releaseControllerLock((String)"OpenJ9AttachProvider.listVirtualMachinesImp");
        }
        return arrayList;
    }

    VirtualMachineDescriptor getDescriptor(String string) {
        List<VirtualMachineDescriptor> list = this.listVirtualMachines();
        if (null != list) {
            for (VirtualMachineDescriptor virtualMachineDescriptor : list) {
                if (!virtualMachineDescriptor.id().equalsIgnoreCase(string)) continue;
                return virtualMachineDescriptor;
            }
        }
        return null;
    }

    @Override
    public String name() {
        return "IBM";
    }

    @Override
    public String type() {
        return "Java SE";
    }

    private static void checkAttachSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(Permissions.ATTACH_VM);
        }
    }

    static class Permissions {
        static final AttachPermission ATTACH_VM = new AttachPermission("attachVirtualMachine", null);

        Permissions() {
        }
    }
}

