/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.http;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;

public enum Protocol {
    HTTP("http", 80),
    HTTPS("https", 443),
    RELATIVE("//", 0),
    WSS("wss", 443);

    @NotNull
    public final String scheme;
    public final int defaultPort;

    private Protocol(String scheme, int defaultPort) {
        if (scheme == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.scheme = scheme;
        this.defaultPort = defaultPort;
    }

    @Nullable
    public static Protocol parse(@NotNull String scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (Protocol p : Protocol.values()) {
            if (!p.scheme.equals(scheme)) continue;
            return p;
        }
        return null;
    }
}

