/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.http;

import com.yourkit.asserts.Asserts;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.Strings;
import com.yourkit.util.http.Protocol;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class HttpUri {
    @NotNull
    private Protocol myProtocol;
    @NotNull
    private String myHost;
    private int myPort;
    @NotNull
    private String myPath;
    @NotNull
    private String myAnchor;
    @NotNull
    private final HashMap<String, List<String>> myParams;

    public HttpUri() {
        this(Protocol.RELATIVE, "");
    }

    public HttpUri(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this(Protocol.RELATIVE, "", -1, path);
    }

    public HttpUri(@NotNull Protocol protocol, @NotNull String host) {
        if (protocol == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this(protocol, host, -1, "");
    }

    public HttpUri(@NotNull Protocol protocol, @NotNull String host, int port) {
        if (protocol == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this(protocol, host, port, "");
    }

    public HttpUri(@NotNull HttpUri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myHost = "";
        this.myPath = "";
        this.myAnchor = "";
        this.myParams = new HashMap(2);
        this.myProtocol = uri.myProtocol;
        this.myHost = uri.myHost;
        this.myPort = uri.myPort;
        this.myPath = uri.myPath;
        this.myAnchor = uri.myAnchor;
        this.myParams.putAll(uri.myParams);
    }

    public HttpUri(@NotNull Protocol protocol, @NotNull String host, @NotNull String path) {
        if (protocol == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        this(protocol, host, -1, path);
    }

    public HttpUri(@NotNull Protocol protocol, @NotNull String host, int port, @NotNull String path) {
        if (protocol == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (host == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Parameter 4 must not be null");
        }
        this.myHost = "";
        this.myPath = "";
        this.myAnchor = "";
        this.myParams = new HashMap(2);
        this.myProtocol = protocol;
        this.setHost(host);
        this.myPort = port;
        this.setPath(path);
    }

    @NotNull
    public Stringifier newStringifier() {
        return new Stringifier();
    }

    @NotNull
    public Protocol getProtocol() {
        Protocol protocol = this.myProtocol;
        if (protocol == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return protocol;
    }

    public HttpUri setProtocol(@NotNull Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myProtocol = protocol;
        return this;
    }

    @NotNull
    public String getHost() {
        String string = this.myHost;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public HttpUri setHost(@NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myHost = Strings.cutPrefix(Strings.cutPostfix(host, "]"), "[");
        return this;
    }

    public int getPort() {
        return this.myPort;
    }

    public int getEffectivePort() {
        int port = this.myPort;
        return port >= 0 ? port : this.myProtocol.defaultPort;
    }

    public HttpUri setPort(int port) {
        this.myPort = port;
        return this;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public HttpUri setPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (path.contains("?")) {
            throw new IllegalArgumentException("Path cannot contains ?; " + path);
        }
        this.myPath = path;
        return this;
    }

    @NotNull
    public String getAnchor() {
        String string = this.myAnchor;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public HttpUri setAnchor(@NotNull String anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Asserts.requireFalse(anchor.contains("#"));
        this.myAnchor = anchor;
        return this;
    }

    @Nullable
    private String getFirstParameter(@Nullable String name) {
        List<String> values = this.myParams.get(name);
        Asserts.requireTrue(values == null || !values.isEmpty());
        return values != null ? values.get(0) : null;
    }

    @Nullable
    public String getParameter(@Nullable String name) {
        return this.getFirstParameter(name);
    }

    public HttpUri setParameter(@NotNull String paramName, @Nullable String paramValue) {
        if (paramName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (Strings.isNullOrEmpty(paramValue)) {
            this.myParams.remove(paramName);
        } else {
            this.myParams.put(paramName, Collections.singletonList(paramValue));
        }
        return this;
    }

    @Nullable
    public List<? extends String> getParameterValues(@Nullable String name) {
        return this.myParams.get(name);
    }

    public HttpUri setParameterValues(@NotNull String paramName, @Nullable List<? extends String> values) {
        if (paramName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (values == null || values.isEmpty()) {
            this.myParams.remove(paramName);
            return this;
        }
        this.myParams.put(paramName, new ArrayList<String>(values));
        return this;
    }

    public HttpUri setParameter(@NotNull String paramName, long paramValue) {
        if (paramName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.setParameter(paramName, Long.toString(paramValue));
        return this;
    }

    public void setParameters(@NotNull Map<String, String> key2Value) {
        if (key2Value == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (Map.Entry<String, String> e : key2Value.entrySet()) {
            this.setParameter(e.getKey(), e.getValue());
        }
    }

    @NotNull
    public Collection<String> getParameterNames() {
        Collection<String> collection = Collections.unmodifiableCollection(this.myParams.keySet());
        if (collection == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return collection;
    }

    @NotNull
    public String getUrlEncodedQuery() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.myParams.entrySet()) {
            String key = Asserts.requireNotEmpty(entry.getKey());
            List values = (List)Asserts.requireNotEmpty((Collection)entry.getValue());
            for (String val : values) {
                if (Strings.isNullOrEmpty(val)) continue;
                if (b.length() > 0) {
                    b.append("&");
                }
                b.append(HttpUri.encodeUrl(key)).append("=").append(HttpUri.encodeUrl(val));
            }
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public String getHostAndPort() {
        StringBuilder result = new StringBuilder();
        result.append(this.getHost());
        int port = this.getPort();
        if (port >= 0) {
            result.append(":").append(port);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public String toString() {
        return this.newStringifier().toString();
    }

    public URI getAsUri() {
        try {
            String path = this.getPath();
            String query = Strings.emptyToNull(this.getUrlEncodedQuery());
            return new URI(this.myProtocol.scheme, null, this.myHost, this.myPort, path, query, null);
        }
        catch (URISyntaxException exc) {
            throw new RuntimeException(exc);
        }
    }

    @Nullable
    public static HttpUri parse(@NotNull String uriStr) {
        if (uriStr == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            return HttpUri.parseOrThrow(uriStr);
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    @NotNull
    public static HttpUri parseOrThrow(@NotNull String uriStr) throws IllegalArgumentException {
        URL url;
        if (uriStr == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (uriStr.contains("?")) {
            throw new IllegalArgumentException("URI cannot contain query; " + uriStr);
        }
        if (uriStr.contains(" ")) {
            throw new IllegalArgumentException("URI cannot contain spaces; " + uriStr);
        }
        try {
            url = new URL(uriStr);
        }
        catch (MalformedURLException exc) {
            throw new IllegalArgumentException("Cannot parse URI; uri=" + uriStr + "; error=" + exc.getMessage());
        }
        Protocol protocol = Protocol.parse(url.getProtocol());
        if (protocol == null) {
            throw new IllegalArgumentException("Cannot parse protocol; " + uriStr);
        }
        return new HttpUri(protocol, url.getHost(), url.getPort(), url.getPath());
    }

    @NotNull
    private static String encodeUrl(@NotNull String url) {
        String string;
        if (url == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            string = URLEncoder.encode(url, Strings.UTF_8.name());
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeException(exc);
        }
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HttpUri)) {
            return false;
        }
        HttpUri uri = (HttpUri)obj;
        return this.myProtocol.equals((Object)uri.myProtocol) && this.myHost.equals(uri.myHost) && this.myPort == uri.myPort && this.myPath.equals(uri.myPath) && this.myAnchor.equals(uri.myAnchor) && this.myParams.equals(uri.myParams);
    }

    public int hashCode() {
        return this.myProtocol.hashCode() + this.myHost.hashCode() + this.myPort + this.myPath.hashCode() + this.myAnchor.hashCode() + this.myParams.hashCode();
    }

    public class Stringifier {
        private boolean myWithProtocol = true;
        private boolean myWithHost = true;
        private boolean myWithPath = true;
        private boolean myWithQuery = true;
        private boolean myWithAnchor = true;

        private Stringifier() {
        }

        @NotNull
        public Stringifier withProtocol(boolean with) {
            this.myWithProtocol = with;
            Stringifier stringifier = this;
            if (stringifier == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return stringifier;
        }

        @NotNull
        public Stringifier withPath(boolean with) {
            this.myWithPath = with;
            Stringifier stringifier = this;
            if (stringifier == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return stringifier;
        }

        @NotNull
        public Stringifier withQuery(boolean with) {
            this.myWithQuery = with;
            Stringifier stringifier = this;
            if (stringifier == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return stringifier;
        }

        public String toString() {
            String query;
            boolean hasPathPart;
            boolean hasHostPart;
            StringBuilder result = new StringBuilder();
            boolean bl = hasHostPart = this.myWithHost && !HttpUri.this.myHost.isEmpty();
            if (hasHostPart) {
                String host;
                if (this.myWithProtocol) {
                    if (HttpUri.this.myProtocol != Protocol.RELATIVE) {
                        result.append(HttpUri.this.getProtocol().scheme).append(":");
                    }
                    result.append("//");
                }
                if ((host = HttpUri.this.getHost()).contains(":")) {
                    result.append('[').append(host).append(']');
                } else {
                    result.append(host);
                }
                int port = HttpUri.this.getPort();
                if (port >= 0 && port != ((HttpUri)HttpUri.this).myProtocol.defaultPort) {
                    result.append(":").append(port);
                }
            }
            boolean bl2 = hasPathPart = this.myWithPath && !HttpUri.this.myPath.isEmpty();
            if (hasPathPart) {
                if (hasHostPart && HttpUri.this.myPath.charAt(0) != '/') {
                    result.append('/');
                }
                result.append(HttpUri.this.myPath);
            }
            if (this.myWithQuery && !(query = HttpUri.this.getUrlEncodedQuery()).isEmpty()) {
                result.append("?").append(query);
            }
            if (this.myWithAnchor && !HttpUri.this.myAnchor.isEmpty()) {
                result.append('#').append(HttpUri.this.myAnchor);
            }
            return result.toString();
        }
    }
}

