/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.Strings;
import java.io.IOException;

public final class StringSanitizerTypeAdapter
extends TypeAdapter<String> {
    @Override
    public String read(@NotNull JsonReader in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return in.nextString();
    }

    @Override
    public void write(@NotNull JsonWriter out, @Nullable String value) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        out.value(Strings.sanitize(value));
    }
}

