/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.cli;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.FileUtil;
import com.yourkit.util.Strings;
import com.yourkit.util.logging.ConsoleLogHandler;
import com.yourkit.util.logging.Logger;
import java.io.File;
import java.io.PrintStream;

public final class CommandLine {
    @NotNull
    private final String[] myArgs;
    @NotNull
    private String myUsage;

    public CommandLine(String ... args) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myUsage = "";
        this.myArgs = args;
    }

    public void configureConsoleLogger() {
        Logger.getLogger().addHandler(new ConsoleLogHandler());
    }

    public boolean isEmpty() {
        return this.myArgs.length == 0;
    }

    public int getArgCount() {
        return this.myArgs.length;
    }

    @NotNull
    public String getArg(int index) {
        String string = this.myArgs[index];
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public String getUsage() {
        String string = this.myUsage;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public void setUsage(@NotNull String usage) {
        if (usage == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myUsage = usage;
    }

    public void printUsage(@NotNull PrintStream out) {
        if (out == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String usage = this.getUsage();
        if (!usage.isEmpty()) {
            out.println("Usage: " + usage);
        }
    }

    public boolean contains(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (String arg : this.myArgs) {
            if (arg.equals(name)) {
                return true;
            }
            int idx = arg.indexOf(61);
            if (idx < 0 || !arg.substring(0, idx).equals(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getParam_String(@NotNull String name, @NotNull String defaultValue) {
        String string;
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String prefix = name + "=";
        for (String arg : this.myArgs) {
            if (!arg.startsWith(prefix)) continue;
            string = arg.substring(prefix.length());
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        string = defaultValue;
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    @Nullable
    public String getParam_String(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String prefix = name + "=";
        for (String arg : this.myArgs) {
            if (!arg.startsWith(prefix)) continue;
            return arg.substring(prefix.length());
        }
        return null;
    }

    @NotNull
    public String getRequiredParam_String(@NotNull String name) throws MissingParamException {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String val = this.getParam_String(name);
        if (val != null) {
            String string = val;
            if (string == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return string;
        }
        throw new MissingParamException("Parameter \"" + name + "\" must be specified.");
    }

    @Nullable
    public File getParam_File(@NotNull String name) throws MissingParamException {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String val = this.getParam_String(name);
        return val != null ? FileUtil.expandAsFile(val) : null;
    }

    @NotNull
    public File getRequiredParam_File(@NotNull String name) throws MissingParamException {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String val = this.getRequiredParam_String(name);
        File file = FileUtil.expandAsFile(val);
        if (file == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return file;
    }

    public int getParam_int(@NotNull String name, int defaultValue) throws IntFormatException {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String val = this.getParam_String(name);
        if (val != null) {
            Integer intVal = Strings.parseInt(val);
            if (intVal != null) {
                return intVal;
            }
            throw new IntFormatException("Parameter \"" + name + "\" must be integer number.");
        }
        return defaultValue;
    }

    public int getParam_int(@NotNull String name) throws IntFormatException {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return this.getParam_int(name, 0);
    }

    public int getRequiredParam_Int(@NotNull String name) throws MissingParamException, IntFormatException {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.getRequiredParam_String(name);
        return this.getParam_int(name);
    }

    public static class IntFormatException
    extends CliException {
        public IntFormatException(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            super(message);
        }
    }

    public static class MissingParamException
    extends CliException {
        public MissingParamException(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            super(message);
        }
    }

    public static class CliException
    extends RuntimeException {
        public CliException(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            super(message);
        }
    }
}

