/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.JniMethodBase;
import com.yourkit.util.UnexpectedValueException;
import java.lang.reflect.Field;

public abstract class JniFieldBase<T> {
    private final boolean myStatic;
    private final long myFieldId;
    @Nullable
    private final Class<? extends T> myClass;
    private final int mySigChar;
    @NotNull
    private final String myTypeName;

    public JniFieldBase(@NotNull Class<? extends T> aClass, @NotNull String fieldName) throws Exception {
        if (aClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        Field field = JniFieldBase.getDeclaredField(aClass, fieldName);
        this.myStatic = (field.getModifiers() & 8) != 0;
        this.myClass = this.myStatic ? aClass : null;
        Class<?> fieldType = field.getType();
        String signature = JniMethodBase.getSignature(fieldType);
        this.mySigChar = signature.charAt(0);
        this.myTypeName = fieldType.getName();
        try {
            this.myFieldId = this.getFieldId(aClass, fieldName, signature, this.myStatic);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    @NotNull
    private static Field getDeclaredField(@NotNull Class<?> aClass, @NotNull String fieldName) throws Exception {
        if (aClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        for (Class<?> c = aClass; c != null; c = c.getSuperclass()) {
            Field field;
            try {
                field = c.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            if (field == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return field;
        }
        throw new NoSuchFieldException(fieldName);
    }

    public <ReturnType> ReturnType get(@Nullable T object) throws Exception {
        this.validateParameters(object);
        if (this.mySigChar == 76 || this.mySigChar == 91) {
            return (ReturnType)this.getFieldObjectValueImpl(this.myClass, this.guardObjectArg(object), this.myFieldId);
        }
        long asLong = this.getFieldPrimValueImpl(this.myClass, this.guardObjectArg(object), this.myFieldId, this.mySigChar);
        return (ReturnType)JniMethodBase.boxPrimitiveValue(asLong, this.mySigChar);
    }

    public long getPrimitive(@Nullable T object) throws Exception {
        this.validateParameters(object);
        if (this.mySigChar == 76 || this.mySigChar == 91) {
            throw new RuntimeException("Cannot get a value of non-primitive field");
        }
        return this.getFieldPrimValueImpl(this.myClass, this.guardObjectArg(object), this.myFieldId, this.mySigChar);
    }

    public int getInt(@Nullable T object) throws Exception {
        return (int)this.getPrimitive(object);
    }

    public boolean getBoolean(T object) throws Exception {
        return this.getPrimitive(object) != 0L;
    }

    public void set(@Nullable T object, @Nullable Object value) throws Exception {
        long valueAsLong;
        this.validateParameters(object);
        if (this.mySigChar == 76 || this.mySigChar == 91) {
            this.setFieldObjectValueImpl(this.myClass, this.guardObjectArg(object), this.myFieldId, value);
            return;
        }
        this.validateBoxedValue(value);
        if (value instanceof Boolean) {
            valueAsLong = Boolean.TRUE.equals(value) ? 1L : 0L;
        } else if (value instanceof Float) {
            valueAsLong = Float.floatToIntBits(((Float)value).floatValue());
        } else if (value instanceof Double) {
            valueAsLong = Double.doubleToLongBits((Double)value);
        } else if (value instanceof Number) {
            valueAsLong = ((Number)value).longValue();
        } else if (value instanceof Character) {
            valueAsLong = ((Character)value).charValue();
        } else {
            throw new UnexpectedValueException(value);
        }
        this.setFieldPrimValueImpl(this.myClass, this.guardObjectArg(object), this.myFieldId, this.mySigChar, valueAsLong);
    }

    private void validateParameters(@Nullable Object object) {
        if (!this.myStatic && object == null) {
            throw new IllegalArgumentException("Object must not be null when accessing an instance field");
        }
    }

    @Nullable
    private T guardObjectArg(T object) {
        return this.myStatic ? null : (T)object;
    }

    private void validateBoxedValue(@Nullable Object value) {
        boolean isOK;
        if (value == null) {
            throw new IllegalArgumentException("Setting null to primitive field");
        }
        switch (this.mySigChar) {
            case 90: {
                isOK = value instanceof Boolean;
                break;
            }
            case 67: {
                isOK = value instanceof Character;
                break;
            }
            case 66: {
                isOK = value instanceof Byte;
                break;
            }
            case 83: {
                isOK = value instanceof Byte || value instanceof Short;
                break;
            }
            case 73: {
                isOK = value instanceof Byte || value instanceof Short || value instanceof Integer;
                break;
            }
            case 74: {
                isOK = value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
                break;
            }
            case 70: {
                isOK = value instanceof Float;
                break;
            }
            case 68: {
                isOK = value instanceof Double;
                break;
            }
            default: {
                throw new UnexpectedValueException(this.mySigChar);
            }
        }
        if (!isOK) {
            throw new IllegalArgumentException("Cannot set " + value.getClass() + " value to " + this.myTypeName + " field");
        }
    }

    protected abstract long getFieldId(@NotNull Class<?> var1, @NotNull String var2, @NotNull String var3, boolean var4) throws Throwable;

    @Nullable
    protected abstract Object getFieldObjectValueImpl(@Nullable Class<? extends T> var1, @Nullable T var2, long var3) throws Exception;

    protected abstract void setFieldObjectValueImpl(@Nullable Class<? extends T> var1, @Nullable T var2, long var3, @Nullable Object var5) throws Exception;

    protected abstract long getFieldPrimValueImpl(@Nullable Class<? extends T> var1, @Nullable T var2, long var3, int var5) throws Exception;

    protected abstract void setFieldPrimValueImpl(@Nullable Class<? extends T> var1, @Nullable T var2, long var3, int var5, long var6) throws Exception;
}

