/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.Asserts;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.MultiVersion;
import java.util.Objects;

public class AppVersion
implements Comparable<AppVersion> {
    private static final int ELEMENT_COUNT = 3;
    @NotNull
    private final MultiVersion myVersion;

    private AppVersion(@NotNull MultiVersion version) {
        if (version == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Asserts.requireEqual(version.length(), 3);
        this.myVersion = version;
    }

    @Nullable
    public static AppVersion parseSafe(@NotNull String versionStr) {
        if (versionStr == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        MultiVersion version = new MultiVersion(versionStr);
        if (version.length() != 3) {
            return null;
        }
        return new AppVersion(version);
    }

    @NotNull
    public static AppVersion parse(@NotNull String versionStr) throws IllegalArgumentException {
        if (versionStr == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        AppVersion appVersion = AppVersion.parseSafe(versionStr);
        if (appVersion == null) {
            throw new IllegalArgumentException("Invalid app version: " + versionStr);
        }
        AppVersion appVersion2 = appVersion;
        if (appVersion2 == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return appVersion2;
    }

    @Override
    public int compareTo(@NotNull AppVersion other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Asserts.requireEqual(other.myVersion.length(), 3);
        return this.myVersion.compareTo(other.myVersion);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppVersion that = (AppVersion)o;
        return Objects.equals(this.myVersion, that.myVersion);
    }

    public int hashCode() {
        return Objects.hash(this.myVersion);
    }

    public String toString() {
        return this.getVersionAs3Numbers();
    }

    @NotNull
    public String getYearDotMonth() {
        String string = this.getYear() + "." + this.getMonth();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public String getVersionAs3Numbers() {
        String string = this.myVersion.asString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public int getYear() {
        return this.myVersion.get(0);
    }

    public int getMonth() {
        return this.myVersion.get(1);
    }

    public int getBuildNumber() {
        return this.myVersion.get(2);
    }
}

