/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.api.controller.v2;

import com.google.gson.JsonElement;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.yourkit.api.ProbeActivityMode;
import com.yourkit.api.controller.ControllerException;
import com.yourkit.api.controller.v2.AdvanceGenerationParam;
import com.yourkit.api.controller.v2.AllocationProfilingSettings;
import com.yourkit.api.controller.v2.CpuProfilingSettings;
import com.yourkit.api.controller.v2.JfrConfig;
import com.yourkit.api.controller.v2.JfrSettings;
import com.yourkit.api.controller.v2.JvmTelemetry;
import com.yourkit.api.controller.v2.Status;
import com.yourkit.api.controller.v2.ThreadProfilingSettings;
import com.yourkit.api.controller.v2.TotalCreatedObjects;
import com.yourkit.asserts.Asserts;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.controller.SelfProfilingUtil;
import com.yourkit.controller.http.HttpTransport;
import com.yourkit.util.gson.GsonUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class Controller {
    @NotNull
    private final HttpTransport myTransport;

    @NotNull
    public static Builder newBuilder() {
        return new Builder();
    }

    private Controller(@NotNull HttpTransport transport) {
        if (transport == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myTransport = transport;
    }

    public void advanceGeneration(@Nullable String description) throws IOException {
        this.myTransport.doRequest("advanceGeneration", new AdvanceGenerationParam(description));
    }

    @NotNull
    public String capturePerformanceSnapshot() throws IOException {
        JsonElement jsonObj = this.myTransport.doRequest("capturePerformanceSnapshot", null);
        String string = HttpTransport.GSON.fromJson((JsonElement)jsonObj, CaptureSnapshotResult.class).myPath;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public String captureMemorySnapshot() throws IOException {
        JsonElement jsonObj = this.myTransport.doRequest("captureMemorySnapshot", null);
        String string = HttpTransport.GSON.fromJson((JsonElement)jsonObj, CaptureSnapshotResult.class).myPath;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public String captureHprofSnapshot() throws IOException {
        JsonElement jsonObj = this.myTransport.doRequest("captureHprofSnapshot", null);
        String string = HttpTransport.GSON.fromJson((JsonElement)jsonObj, CaptureSnapshotResult.class).myPath;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public InetSocketAddress getAddress() {
        InetSocketAddress inetSocketAddress = this.myTransport.getAddress();
        if (inetSocketAddress == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return inetSocketAddress;
    }

    public void forceGc() throws IOException {
        this.myTransport.doRequest("forceGc", null);
    }

    @NotNull
    public JvmTelemetry getJvmTelemetry() throws IOException {
        JsonElement jsonObj = this.myTransport.doRequest("getJvmTelemetry", null);
        JvmTelemetry jvmTelemetry = HttpTransport.GSON.fromJson(jsonObj, JvmTelemetry.class);
        if (jvmTelemetry == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return jvmTelemetry;
    }

    @NotNull
    public Status getStatus() throws IOException {
        JsonElement jsonObj = this.myTransport.doRequest("getStatus", null);
        Status status = HttpTransport.GSON.fromJson(jsonObj, Status.class);
        if (status == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return status;
    }

    @NotNull
    public TotalCreatedObjects getTotalCreatedObjects() throws IOException {
        JsonElement jsonObj = this.myTransport.doRequest("getTotalCreatedObjects", null);
        TotalCreatedObjects totalCreatedObjects = HttpTransport.GSON.fromJson(jsonObj, TotalCreatedObjects.class);
        if (totalCreatedObjects == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return totalCreatedObjects;
    }

    @NotNull
    public Map<? extends String, ? extends ProbeActivityMode> getProbeActivityModes() throws IOException {
        JsonElement jsonObj = this.myTransport.doRequest("getProbeActivityModes", null);
        Map<String, ProbeActivityMode> map = GsonUtil.deserializeMap(HttpTransport.GSON, jsonObj, String.class, ProbeActivityMode.class);
        if (map == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return map;
    }

    public void setProbeActivityModes(@NotNull Map<? extends String, ? extends ProbeActivityMode> probeClassName2Mode) throws IOException {
        if (probeClassName2Mode == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myTransport.doRequest("setProbeActivityModes", probeClassName2Mode);
    }

    @NotNull
    public String getTriggers() throws IOException {
        JsonElement jsonObj = this.myTransport.doRequest("getTriggers", null);
        String string = HttpTransport.GSON.fromJson((JsonElement)jsonObj, GetTriggersResult.class).myTriggers;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public void setTriggers(@NotNull String triggers, boolean append) throws IOException, ControllerException {
        if (triggers == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        SetTriggersParams params = new SetTriggersParams(triggers, append);
        this.myTransport.doRequest("setTriggers", params);
    }

    public void resetAllocationProfiling() throws IOException {
        this.myTransport.doRequest("resetAllocationProfiling", null);
    }

    public void resetCpuProfiling() throws IOException {
        this.myTransport.doRequest("resetCpuProfiling", null);
    }

    public void clearEventTables(@NotNull List<? extends String> tableNames) throws IOException {
        if (tableNames == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        ClearEventTables param = new ClearEventTables();
        param.myTables = tableNames;
        this.myTransport.doRequest("clearEventTables", param);
    }

    public void resetExceptionProfiling() throws IOException {
        this.myTransport.doRequest("resetExceptionProfiling", null);
    }

    public void resetMonitorProfiling() throws IOException {
        this.myTransport.doRequest("resetMonitorProfiling", null);
    }

    public void startAllocationProfiling(@NotNull AllocationProfilingSettings settings) throws IOException, ControllerException {
        if (settings == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myTransport.doRequest("startAllocationProfiling", settings);
    }

    public void startAsyncSamplingCpu(@NotNull CpuProfilingSettings settings) throws IOException, ControllerException {
        if (settings == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myTransport.doRequest("startAsyncSamplingCpu", settings);
    }

    public void startAsyncSamplingPeriodic(@NotNull CpuProfilingSettings settings) throws IOException, ControllerException {
        if (settings == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myTransport.doRequest("startAsyncSamplingPeriodic", settings);
    }

    public void stopAllocationProfiling() throws IOException {
        this.myTransport.doRequest("stopAllocationProfiling", null);
    }

    public void startCallCounting() throws IOException, ControllerException {
        this.myTransport.doRequest("startCallCounting", null);
    }

    public void startExceptionProfiling() throws IOException {
        this.myTransport.doRequest("startExceptionProfiling", null);
    }

    public void stopExceptionProfiling() throws IOException {
        this.myTransport.doRequest("stopExceptionProfiling", null);
    }

    public void startMonitorProfiling() throws IOException {
        this.myTransport.doRequest("startMonitorProfiling", null);
    }

    public void stopMonitorProfiling() throws IOException {
        this.myTransport.doRequest("stopMonitorProfiling", null);
    }

    public void startSampling(@NotNull CpuProfilingSettings settings) throws IOException, ControllerException {
        if (settings == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myTransport.doRequest("startSampling", settings);
    }

    public void startThreadProfiling(@NotNull ThreadProfilingSettings settings) throws IOException {
        if (settings == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myTransport.doRequest("startThreadProfiling", settings);
    }

    public void stopThreadProfiling() throws IOException {
        this.myTransport.doRequest("stopThreadProfiling", null);
    }

    public void resetThreadProfiling() throws IOException {
        this.myTransport.doRequest("resetThreadProfiling", null);
    }

    public void startTelemetry() throws IOException {
        this.myTransport.doRequest("startTelemetry", null);
    }

    public void stopTelemetry() throws IOException {
        this.myTransport.doRequest("stopTelemetry", null);
    }

    public void resetTelemetry() throws IOException {
        this.myTransport.doRequest("resetTelemetry", null);
    }

    public void startTracing(@NotNull CpuProfilingSettings settings) throws IOException, ControllerException {
        if (settings == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myTransport.doRequest("startTracing", settings);
    }

    public void stopCpuProfiling() throws IOException {
        this.myTransport.doRequest("stopCpuProfiling", null);
    }

    @NotNull
    public List<JfrConfig> getJfrConfigs() throws IOException {
        JsonElement jsonObj = this.myTransport.doRequest("getJfrConfigs", null);
        List<JfrConfig> list = GsonUtil.deserializeList(HttpTransport.GSON, jsonObj, List.class, JfrConfig.class);
        if (list == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return list;
    }

    public void startJfr(@NotNull JfrSettings settings) throws IOException, ControllerException {
        if (settings == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myTransport.doRequest("startJfr", settings);
    }

    public void stopJfr() throws IOException, ControllerException {
        this.myTransport.doRequest("stopJfr", null);
    }

    public void resetJfr() throws IOException, ControllerException {
        this.myTransport.doRequest("resetJfr", null);
    }

    @NotNull
    public String captureJfrSnapshot() throws IOException, ControllerException {
        JsonElement jsonObj = this.myTransport.doRequest("captureJfrSnapshot", null);
        String string = HttpTransport.GSON.fromJson((JsonElement)jsonObj, CaptureSnapshotResult.class).myPath;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    private static final class CaptureSnapshotResult {
        @Expose
        @SerializedName(value="path")
        @NotNull
        public String myPath = "";
    }

    private static final class SetTriggersParams {
        @Expose
        @SerializedName(value="triggers")
        @NotNull
        public final String myTriggers;
        @Expose
        @SerializedName(value="append")
        public final boolean myAppend;

        public SetTriggersParams(@NotNull String triggers, boolean append) {
            if (triggers == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            this.myTriggers = triggers;
            this.myAppend = append;
        }
    }

    private static final class GetTriggersResult {
        @Expose
        @SerializedName(value="triggers")
        @NotNull
        public final String myTriggers;

        public GetTriggersResult(@NotNull String triggers) {
            if (triggers == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            this.myTriggers = triggers;
        }
    }

    private static final class ClearEventTables {
        @Expose
        @SerializedName(value="tables")
        @NotNull
        List<? extends String> myTables = Collections.emptyList();
    }

    public static final class Builder {
        @Nullable
        private String myHost;
        private int myPort;
        @Nullable
        private String myReverseProxyPath;
        private boolean myTrustAllSslCertificates = true;
        private int myConnectTimeoutMs;
        private int myReadTimeoutMs;

        private Builder() {
        }

        public Builder self() {
            return this.port(-1);
        }

        @NotNull
        public Builder host(@NotNull String host) {
            if (host == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            this.myHost = host;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder port(int port) {
            this.myPort = port;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder reverseProxyPath(@Nullable String path) {
            this.myReverseProxyPath = path;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder connectTimeout(int ms) {
            this.myConnectTimeoutMs = ms;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder readTimeout(int ms) {
            this.myReadTimeoutMs = ms;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder trustAllSslCertificates(boolean trust) {
            this.myTrustAllSslCertificates = trust;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return builder;
        }

        @NotNull
        private InetSocketAddress getAgentAddress() {
            int timeoutMs = this.myConnectTimeoutMs > 0 ? this.myConnectTimeoutMs : 30000;
            InetSocketAddress inetSocketAddress = SelfProfilingUtil.getAgentAddress(timeoutMs);
            if (inetSocketAddress == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return inetSocketAddress;
        }

        @NotNull
        public Controller build() {
            if (this.myPort < 0) {
                InetSocketAddress address = this.getAgentAddress();
                this.myPort = address.getPort();
                this.myHost = address.getHostString();
            }
            Asserts.requireFalse(this.myPort < 1 || this.myPort > 65535, "Port out of range:" + this.myPort);
            HttpTransport transport = HttpTransport.newBuilder().host(this.myHost).port(this.myPort).apiVersion("v2").reverseProxyPath(this.myReverseProxyPath).trustAllSslCertificates(this.myTrustAllSslCertificates).connectTimeout(this.myConnectTimeoutMs).readTimeout(this.myReadTimeoutMs).build();
            return new Controller(transport);
        }
    }
}

