#!/bin/sh

# ------------------------------------------------------------------------------
# YourKit Java Profiler startup script
# ------------------------------------------------------------------------------

# Add path with aws in it
export PATH="$PATH:/usr/local/bin"

if [ "$(uname | grep Linux)" ] ; then
  Y0=$(readlink -f "$0")
else
  Y0=$(readlink "$0" 2>/dev/null)
fi
if [ -z "$Y0" ] ; then
  Y0="$0"
fi

YH="$YOURKIT_HOME"
if [ -z "$YH" ] ; then
  YH="$HOME"
fi

YS="$YH/.yjp"
if [ -z "$YH" ] ; then
  YH="$HOME"
fi

YD="$(dirname "$Y0")/.."

# ensure empty
ARCH=

# macOS
if [ "$(uname)" = "Darwin" ] ; then
  if [ "$(/usr/sbin/sysctl -a | grep 'hw.optional.arm64: 1')" ] ; then
    ARCH="arch -arm64"
  fi
fi

if [ -n "$YJP_JAVA_HOME" ] ; then
  ARCH=
  JAVA_EXE="$YJP_JAVA_HOME/bin/java"
  if [ ! -r "$JAVA_EXE" ] ; then
    JAVA_EXE="$YJP_JAVA_HOME/jre/bin/java"
  fi
elif [ "$(uname)" = "Darwin" ] ; then
  JAVA_EXE="$YD/../jdk/Contents/Home/bin/java"
elif [ "$(uname | grep Linux)" ] ; then
  if [ "$(uname -m | grep x86_64)" ] || [ "$(uname -m | grep aarch64)" ] || [ "$(uname -m | grep arm64)" ] ; then
    if [ "$(getconf LONG_BIT | grep 64)" ] ; then
      JAVA_EXE="$YD/jre64/bin/java"
      if [ ! -x "$JAVA_EXE" ]; then
        echo "YourKit Java Profiler installation is corrupt: the bundled JRE does not have executable permission."
        echo "Please use unzip command in console to unpack the installation zip."
        exit 1
      fi
    fi
  fi
fi

if [ ! -r "$JAVA_EXE" ] && [ -n "$JAVA_HOME" ] ; then
  ARCH=
  JAVA_EXE="$JAVA_HOME/bin/java"
fi

if [ ! -r "$JAVA_EXE" ] ; then
  ARCH=
  JAVA_EXE=java
fi

JAVA_VERSION="$("$JAVA_EXE" -version 2>&1)"

if [ -z "$(echo "$JAVA_VERSION" | grep version)" ] ; then
  echo "Cannot find Java to run YourKit Java Profiler."
  echo "Java search sequence:"
  echo " - environment variable YJP_JAVA_HOME"
  echo " - bundled JRE"
  echo " - environment variable JAVA_HOME"
  echo " - 'java' in PATH"
  exit
fi

unset JAVA_TOOL_OPTIONS

JAVA_HEAP_LIMIT="-Xmx8G"

# If you use Xmonad window manager, uncomment next 3 lines:
# _JAVA_AWT_WM_NONREPARENTING=1
# export _JAVA_AWT_WM_NONREPARENTING
# wmname LG3D

if [ -f "$YS/ui.ini" ] ; then
  INI_PARAMS="$(cat "$YS/ui.ini" | grep -v '#')"
else
  INI_PARAMS="-Dyk.empty.param"
fi

INI_PARAMS="-Djava.awt.smartInvalidate=true -Djna.nosys=true $INI_PARAMS"

if [ "$(uname)" = "Darwin" ] ; then
  INI_PARAMS="$INI_PARAMS -Dapple.laf.useScreenMenuBar=true"
  # don't mix with INI_PARAMS, otherwise macOS icon will disappear
  DOCK_PARAMS="-Xdock:icon=$YD/yjp.icns"
else
  DOCK_PARAMS="-Dyk.empty.param"
fi

# see_enable_jvm_enumeration
AE="--add-exports=jdk.internal.jvmstat/sun.jvmstat.monitor=ALL-UNNAMED"

if [ "$(echo "$@" | grep ideport)" ] ; then
  exec $ARCH "$JAVA_EXE" $JAVA_HEAP_LIMIT $INI_PARAMS "$DOCK_PARAMS" $AE -jar "$YD/lib/yourkit.jar" "$@" &
  exit
fi

$ARCH "$JAVA_EXE" $JAVA_HEAP_LIMIT $INI_PARAMS "$DOCK_PARAMS" $AE -jar "$YD/lib/yourkit.jar" "$@"
while [ $? -eq 19 ]; do
  if [ "$(uname)" = "Darwin" ] ; then
    # Open as macOS app
    open -n "$(dirname "$YD/../../..")"
    exit 0
  fi

  $ARCH "$JAVA_EXE" $JAVA_HEAP_LIMIT $INI_PARAMS "$DOCK_PARAMS" $AE -jar "$YD/lib/yourkit.jar"
done
