/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.tools;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.tools.attach.diagnostics.attacher.AttacherDiagnosticsProvider;

public class Util {
    private static final String SUN_JAVA_COMMAND = "sun.java.command";
    private static final String SUN_JVM_ARGS = "sun.jvm.args";
    private static final String[] HELP_OPTIONS = new String[]{"-h", "help", "-help", "--help"};

    public static List<String> inStreamToStringList(InputStream inputStream) {
        List<String> list;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            list = bufferedReader.lines().map(string -> string.trim()).filter(string -> !string.isEmpty()).collect(Collectors.toList());
        }
        catch (IOException iOException) {
            list = Collections.emptyList();
        }
        return list;
    }

    static void runCommandAndPrintResult(AttacherDiagnosticsProvider attacherDiagnosticsProvider, String string, String string2) throws IOException {
        Properties properties = attacherDiagnosticsProvider.executeDiagnosticCommand(string);
        DiagnosticProperties.dumpPropertiesIfDebug((String)(string2 + " result:"), (Properties)properties);
        String string3 = new DiagnosticProperties(properties).printStringResult();
        System.out.print(string3);
    }

    static void handleCommandException(String string, Exception exception) {
        String string2 = "Error getting data from %s";
        String string3 = exception.getMessage();
        string2 = null != string3 ? (string3.matches("OPENJ9_INCOMPATIBLE_JAVA_VERSION") ? string2 + ": incompatible target JVM%n" : string2 + ": %s%n") : string2 + "%n";
        System.err.printf(string2, string, string3);
        if (DiagnosticProperties.isDebug) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getTargetInformation(AttachProvider attachProvider, VirtualMachineDescriptor virtualMachineDescriptor, boolean bl, boolean bl2, boolean bl3, StringBuilder stringBuilder) {
        try {
            VirtualMachine virtualMachine = attachProvider.attachVirtualMachine(virtualMachineDescriptor);
            try {
                int n;
                Object object;
                Properties properties = virtualMachine.getSystemProperties();
                String string = properties.getProperty(SUN_JAVA_COMMAND, "");
                String[] stringArray = string.split("\\s+", 2);
                if (bl2) {
                    object = stringArray[0];
                    n = -1;
                    n = ((String)object).toLowerCase().endsWith(".jar") ? ((String)object).lastIndexOf(File.pathSeparatorChar) : ((String)object).lastIndexOf(46);
                    stringArray[0] = ((String)object).substring(n + 1);
                }
                if (bl3) {
                    object = stringArray;
                    n = ((String[])object).length;
                    for (int i = 0; i < n; ++i) {
                        Object object2 = object[i];
                        stringBuilder.append(' ');
                        stringBuilder.append((String)object2);
                    }
                } else if (stringArray.length > 0) {
                    stringBuilder.append(' ');
                    stringBuilder.append(stringArray[0]);
                }
                if (bl && null != (object = properties.getProperty(SUN_JVM_ARGS)) && !((String)object).isEmpty()) {
                    stringBuilder.append(' ').append((String)object);
                }
            }
            finally {
                virtualMachine.detach();
            }
        }
        catch (AttachNotSupportedException | IOException exception) {
            stringBuilder.append(" <no information available>");
        }
    }

    static void printProperties(PrintStream printStream, Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            printStream.printf("%s=%s%n", entry.getKey(), entry.getValue());
        }
    }

    static void exitJVMWithReasonAndHelp(String string, String string2) {
        if (string != null && !string.isEmpty()) {
            System.out.println(string);
        }
        System.out.printf(string2, new Object[0]);
        System.exit(1);
    }

    static boolean checkHelpOption(String string) {
        return Arrays.stream(HELP_OPTIONS).anyMatch(string::equalsIgnoreCase);
    }
}

