/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.internal.tools.attach.target.DiagnosticUtils;
import openj9.internal.tools.attach.target.IPC;
import openj9.tools.attach.diagnostics.attacher.AttacherDiagnosticsProvider;
import openj9.tools.attach.diagnostics.tools.Util;

public class Jmap {
    private static List<String> vmids;
    private static boolean histo;
    private static boolean live;
    private static String HELPTEXT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (!Jmap.parseArguments(stringArray)) {
            System.exit(1);
        }
        AttacherDiagnosticsProvider attacherDiagnosticsProvider = new AttacherDiagnosticsProvider();
        String string = AttachHandler.getVmId();
        for (String string2 : vmids) {
            long l;
            if (string2.equals(string)) continue;
            if (string2.matches("\\d+") && !IPC.processExists((long)(l = Long.parseLong(string2)))) {
                System.out.println("No such process: " + string2);
                continue;
            }
            try {
                if (vmids.size() > 1) {
                    System.out.printf("Virtual machine: %s%n", string2);
                }
                attacherDiagnosticsProvider.attach(string2);
                if (!histo) continue;
                Util.runCommandAndPrintResult(attacherDiagnosticsProvider, DiagnosticUtils.makeHeapHistoCommand((boolean)live), "jmap");
            }
            catch (Exception exception) {
                System.err.printf("Error getting data from %s", string2);
                String string3 = exception.getMessage();
                if (null == string3) {
                    System.err.println();
                } else if (string3.matches("OPENJ9_INCOMPATIBLE_JAVA_VERSION")) {
                    System.err.println(": incompatible target JVM");
                } else {
                    System.err.printf(": %s%n", string3);
                }
                if (!DiagnosticProperties.isDebug) continue;
                exception.printStackTrace();
            }
            finally {
                try {
                    attacherDiagnosticsProvider.detach();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean parseArguments(String[] stringArray) {
        vmids = new ArrayList<String>();
        histo = false;
        live = false;
        int n = 0;
        String string = null;
        vmids = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (!string2.startsWith("-")) {
                vmids.add(string2);
                continue;
            }
            boolean bl = false;
            String[] stringArray2 = string2.split(":");
            if (stringArray2.length > 2) {
                bl = true;
            } else if ("-histo".equalsIgnoreCase(stringArray2[0])) {
                if (stringArray2.length == 2) {
                    if ("live".equalsIgnoreCase(stringArray2[1])) {
                        live = true;
                    } else {
                        bl = true;
                    }
                }
                if (!bl) {
                    histo = true;
                    ++n;
                }
            } else {
                bl = true;
            }
            if (!bl) continue;
            string = "unrecognized option " + string2;
            break;
        }
        if (string == null && n != 1) {
            string = "exactly one option must be selected";
        }
        if (null != string) {
            System.err.printf("%s%n" + HELPTEXT, string);
        } else if (vmids.isEmpty()) {
            vmids = Util.inStreamToStringList(System.in);
        }
        return null == string && !vmids.isEmpty();
    }

    static {
        HELPTEXT = "jmap: obtain heap information about a Java process%n Usage:%n    jmap <option>* <vmid>%n        <vmid>: Attach API VM ID as shown in jps or other Attach API-based tools%n        <vmid>s are read from stdin if none are supplied as arguments%n    -histo: print statistics about classes on the heap, including number of objects and aggregate size%n    -histo:live : Print only live objects%n    -J: supply arguments to the Java VM running jmap%nNOTE: this utility might significantly affect the performance of the target VM.%nAt least one option must be selected.%n";
    }
}

