/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.attacher;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.attacher.OpenJ9AttachProvider;
import com.ibm.tools.attach.attacher.OpenJ9VirtualMachine;
import com.sun.tools.attach.AttachNotSupportedException;
import java.io.IOException;
import java.util.Properties;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.internal.tools.attach.target.IPC;

public class AttacherDiagnosticsProvider {
    private OpenJ9VirtualMachine vm;

    public Properties executeDiagnosticCommand(String string) throws IOException {
        IPC.logMessage((String)"enter executeDiagnosticCommand ", (String)string);
        this.checkAttached();
        Properties properties = this.vm.executeDiagnosticCommand(string);
        DiagnosticProperties.dumpPropertiesIfDebug((String)"Properties from target:", (Properties)properties);
        IPC.logMessage((String)"exit getRemoteThreadGroupInfo");
        return properties;
    }

    public void attach(String string) throws IOException {
        OpenJ9AttachProvider openJ9AttachProvider = new OpenJ9AttachProvider();
        IPC.logMessage((String)"DiagnosticsProviderImpl attaching to ", (String)string);
        try {
            this.vm = openJ9AttachProvider.attachVirtualMachine(string);
        }
        catch (AttachNotSupportedException attachNotSupportedException) {
            throw new IOException(Msg.getString((String)"K0809", (Object)string));
        }
        IPC.logMessage((String)"DiagnosticsProviderImpl attached to ", (String)string);
    }

    public void detach() throws IOException {
        if (null != this.vm) {
            this.vm.detach();
            this.vm = null;
        }
    }

    public Properties getSystemProperties() throws IOException {
        this.checkAttached();
        return this.vm.getSystemProperties();
    }

    public Properties getAgentProperties() throws IOException {
        this.checkAttached();
        return this.vm.getAgentProperties();
    }

    private void checkAttached() throws IOException {
        if (null == this.vm) {
            throw new IOException(Msg.getString((String)"K0554"));
        }
    }
}

