/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.attacher;

import com.ibm.oti.util.Msg;
import com.ibm.tools.attach.attacher.OpenJ9AttachProvider;
import com.ibm.tools.attach.attacher.OpenJ9VirtualMachineDescriptor;
import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachOperationFailedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.AttachmentConnection;
import openj9.internal.tools.attach.target.CommonDirectory;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.internal.tools.attach.target.DiagnosticUtils;
import openj9.internal.tools.attach.target.FileLock;
import openj9.internal.tools.attach.target.IPC;
import openj9.internal.tools.attach.target.Reply;
import openj9.internal.tools.attach.target.Response;
import openj9.internal.tools.attach.target.TargetDirectory;

public final class OpenJ9VirtualMachine
extends VirtualMachine
implements Response {
    private static final int ATTACH_CONNECTED_MESSAGE_LENGTH_LIMIT = 4000;
    private static final int DEFAULT_ATTACH_TIMEOUT = 120000;
    private static final int DEFAULT_COMMAND_TIMEOUT = 0;
    private static int MAXIMUM_ATTACH_TIMEOUT;
    private static int COMMAND_TIMEOUT;
    private static final String INSTRUMENT_LIBRARY = "instrument";
    private OutputStream commandStream;
    private final OpenJ9VirtualMachineDescriptor descriptor;
    private final OpenJ9AttachProvider myProvider;
    private Integer portNumber;
    private InputStream responseStream;
    private boolean targetAttached;
    private String targetId;
    private FileLock[] targetLocks;
    private ServerSocket targetServer;
    private Socket targetSocket;

    OpenJ9VirtualMachine(AttachProvider attachProvider, String string) throws NullPointerException {
        super(attachProvider, string);
        if (null == string || null == attachProvider) {
            throw new NullPointerException(Msg.getString((String)"K0554"));
        }
        this.targetId = string;
        this.myProvider = (OpenJ9AttachProvider)attachProvider;
        this.descriptor = (OpenJ9VirtualMachineDescriptor)this.myProvider.getDescriptor(string);
    }

    void attachTarget() throws IOException, AttachNotSupportedException {
        PrivilegedExceptionAction<Object> privilegedExceptionAction = () -> {
            this.attachTargetImpl();
            return null;
        };
        try {
            AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof AttachNotSupportedException) {
                throw (AttachNotSupportedException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    private void attachTargetImpl() throws AttachNotSupportedException, IOException {
        if (null == this.descriptor) {
            throw new AttachNotSupportedException(Msg.getString((String)"K0531", (Object)this.targetId));
        }
        AttachNotSupportedException attachNotSupportedException = null;
        int n = 500;
        while (n < MAXIMUM_ATTACH_TIMEOUT) {
            attachNotSupportedException = null;
            try {
                this.tryAttachTarget(n);
            }
            catch (AttachNotSupportedException attachNotSupportedException2) {
                IPC.logMessage((String)("attachTarget " + this.targetId + " timeout after " + n + " ms"));
                attachNotSupportedException = attachNotSupportedException2;
                n = n * 3 / 2;
            }
            if (null != attachNotSupportedException) continue;
        }
        if (null != attachNotSupportedException) {
            throw attachNotSupportedException;
        }
        IPC.logMessage((String)"OpenJ9VirtualMachine.attachTargetImpl() finished");
    }

    private static String createLoadAgent(String string, String string2) {
        String string3 = null == string2 ? "" : string2;
        String string4 = "ATTACH_LOADAGENT(instrument," + string + '=' + string3 + ')';
        return string4;
    }

    private static String createLoadAgentLibrary(String string, String string2, boolean bl) {
        String string3 = bl ? "ATTACH_LOADAGENTPATH" : "ATTACH_LOADAGENTLIBRARY";
        String string4 = "";
        if (null != string2 && !string2.equals("")) {
            string4 = ',' + string2;
        }
        String string5 = string3 + '(' + string + string4 + ')';
        return string5;
    }

    @Override
    public synchronized void detach() throws IOException {
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)"ATTACH_DETACH");
        try {
            AttachmentConnection.streamReceiveString((InputStream)this.responseStream);
        }
        finally {
            IPC.logMessage((String)"VirtualMachine.detach");
            if (null != this.commandStream) {
                this.commandStream.close();
                this.commandStream = null;
            }
            if (null != this.targetSocket) {
                this.targetSocket.close();
                this.targetSocket = null;
            }
            if (null != this.targetServer) {
                this.targetServer.close();
                this.targetServer = null;
            }
        }
        this.targetAttached = false;
    }

    @Override
    public Properties getAgentProperties() throws IOException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString((String)"K0544"));
        }
        Properties properties = this.getTargetProperties(false);
        return properties;
    }

    @Override
    public Properties getSystemProperties() throws IOException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString((String)"K0544"));
        }
        Properties properties = this.getTargetProperties(true);
        return properties;
    }

    private synchronized Properties getTargetProperties(boolean bl) throws IOException {
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)(bl ? "ATTACH_GETSYSTEMPROPERTIES" : "ATTACH_GETAGENTPROPERTIES"));
        return IPC.receiveProperties((InputStream)this.responseStream, (boolean)true);
    }

    @Override
    public synchronized void loadAgent(String string, String string2) throws AgentLoadException, AgentInitializationException, IOException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString((String)"K0544"));
        }
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)OpenJ9VirtualMachine.createLoadAgent(string, string2));
        String string3 = AttachmentConnection.streamReceiveString((InputStream)this.responseStream);
        OpenJ9VirtualMachine.parseResponse(string3);
    }

    @Override
    public synchronized void loadAgentLibrary(String string, String string2) throws AgentLoadException, AgentInitializationException, IOException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString((String)"K0544"));
        }
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)OpenJ9VirtualMachine.createLoadAgentLibrary(string, string2, false));
        String string3 = AttachmentConnection.streamReceiveString((InputStream)this.responseStream);
        OpenJ9VirtualMachine.parseResponse(string3);
    }

    @Override
    public synchronized void loadAgentPath(String string, String string2) throws AgentLoadException, AgentInitializationException, IOException {
        if (null == string) {
            throw new AgentLoadException(Msg.getString((String)"K0577"));
        }
        if (!this.targetAttached) {
            throw new IOException(Msg.getString((String)"K0544"));
        }
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)OpenJ9VirtualMachine.createLoadAgentLibrary(string, string2, true));
        String string3 = AttachmentConnection.streamReceiveString((InputStream)this.responseStream);
        OpenJ9VirtualMachine.parseResponse(string3);
    }

    public Properties executeDiagnosticCommand(String string) throws IOException {
        IPC.logMessage((String)"enter executeDiagnosticCommand ", (String)string);
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)("ATTACH_DIAGNOSTICS:" + string));
        return IPC.receiveProperties((InputStream)this.responseStream, (boolean)true);
    }

    private void lockAllAttachNotificationSyncFiles(List<VirtualMachineDescriptor> list) {
        int n = 0;
        this.targetLocks = new FileLock[list.size()];
        for (VirtualMachineDescriptor virtualMachineDescriptor : list) {
            OpenJ9VirtualMachineDescriptor openJ9VirtualMachineDescriptor;
            try {
                openJ9VirtualMachineDescriptor = (OpenJ9VirtualMachineDescriptor)virtualMachineDescriptor;
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            if (!openJ9VirtualMachineDescriptor.id().equalsIgnoreCase(AttachHandler.getVmId())) {
                String string = openJ9VirtualMachineDescriptor.getAttachSyncFileValue();
                if (null != string) {
                    IPC.logMessage((String)"lockAllAttachNotificationSyncFiles locking targetLocks[", (int)n, (String)"] ", (String)string);
                    this.targetLocks[n] = new FileLock(string, 438);
                    try {
                        this.targetLocks[n].lockFile(true, "OpenJ9VirtualMachine.lockAllAttachNotificationSyncFiles");
                    }
                    catch (IOException iOException) {
                        this.targetLocks[n] = null;
                        IPC.logMessage((String)"lockAllAttachNotificationSyncFiles locking targetLocks[", (int)n, (String)"] ", (String)"already locked");
                    }
                }
            } else {
                this.targetLocks[n] = null;
            }
            ++n;
        }
    }

    private static boolean parseResponse(String string) throws IOException, AgentInitializationException, AgentLoadException, IllegalArgumentException, AttachOperationFailedException {
        if (string.startsWith("ATTACH_ERR")) {
            int n = string.indexOf(0);
            String string2 = -1 == n ? string : string.substring(0, n);
            if (string.contains("IOException")) {
                throw new IOException(Msg.getString((String)"K0576", (Object)string2));
            }
            if (string.contains("AgentInitializationException")) {
                Integer n2 = OpenJ9VirtualMachine.getStatusValue(string2);
                if (null == n2) {
                    throw new AgentInitializationException(string2);
                }
                throw new AgentInitializationException(string2, n2);
            }
            if (string.contains("AgentLoadException")) {
                throw new AgentLoadException(string2);
            }
            if (string.contains("IOException")) {
                throw new IOException(Msg.getString((String)"K0576", (Object)string2));
            }
            if (string.contains("IllegalArgumentException")) {
                throw new IllegalArgumentException(Msg.getString((String)"K05de", (Object)string2));
            }
            if (string.contains("AttachOperationFailedException")) {
                throw new AttachOperationFailedException(Msg.getString((String)"k05dc", (Object)string2));
            }
            return false;
        }
        return string.startsWith("ATTACH_ACK") || string.startsWith("ATTACH_RESULT=");
    }

    private static Integer getStatusValue(String string) {
        Pattern pattern = Pattern.compile("(-?\\d+)\\s*$");
        Matcher matcher = pattern.matcher(string);
        Integer n = null;
        if (matcher.find()) {
            String string2 = matcher.group(1);
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                IPC.logMessage((String)"Error parsing response", (String)string);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void tryAttachTarget(int n) throws IOException, AttachNotSupportedException {
        Object object;
        Reply reply = null;
        AttachHandler.waitForAttachApiInitialization();
        IPC.logMessage((String)"VirtualMachineImpl.tryAttachtarget");
        Object object2 = object = AttachHandler.getMainHandler().getIgnoreNotification();
        synchronized (object2) {
            int n2;
            block30: {
                List<VirtualMachineDescriptor> list;
                block28: {
                    block29: {
                        n2 = 0;
                        try {
                            CommonDirectory.obtainAttachLock((String)("OpenJ9VirtualMachine.tryAttachTarget(" + n + ")"));
                            IPC.logMessage((String)"OpenJ9VirtualMachine.tryAttachTarget() before listVirtualMachines");
                            list = this.myProvider.listVirtualMachines();
                            if (null != list) break block28;
                            IPC.logMessage((String)"OpenJ9VirtualMachine.tryAttachTarget() myProvider.listVirtualMachines() returns null");
                            if (null == reply) break block29;
                        }
                        catch (Throwable throwable) {
                            if (null != reply) {
                                reply.deleteReply();
                            }
                            if (n2 > 0) {
                                this.unlockAllAttachNotificationSyncFiles();
                                CommonDirectory.cancelNotify((int)n2, (boolean)this.descriptor.isGlobalSemaphore());
                                if (n2 > 2) {
                                    try {
                                        int n3 = 100 * (n2 > 10 ? 10 : n2);
                                        IPC.logMessage((String)"attachTarget sleep for ", (int)n3);
                                        Thread.sleep(n3);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        IPC.logMessage((String)"attachTarget sleep interrupted");
                                    }
                                }
                            }
                            CommonDirectory.releaseAttachLock((String)("OpenJ9VirtualMachine.tryAttachTarget(" + n + ")"));
                            throw throwable;
                        }
                        reply.deleteReply();
                    }
                    if (n2 > 0) {
                        this.unlockAllAttachNotificationSyncFiles();
                        CommonDirectory.cancelNotify((int)n2, (boolean)this.descriptor.isGlobalSemaphore());
                        if (n2 > 2) {
                            try {
                                int n4 = 100 * (n2 > 10 ? 10 : n2);
                                IPC.logMessage((String)"attachTarget sleep for ", (int)n4);
                                Thread.sleep(n4);
                            }
                            catch (InterruptedException interruptedException) {
                                IPC.logMessage((String)"attachTarget sleep interrupted");
                            }
                        }
                    }
                    CommonDirectory.releaseAttachLock((String)("OpenJ9VirtualMachine.tryAttachTarget(" + n + ")"));
                    return;
                }
                IPC.logMessage((String)"OpenJ9VirtualMachine.tryAttachTarget() myProvider.listVirtualMachines() returns");
                this.targetServer = new ServerSocket(0);
                this.portNumber = this.targetServer.getLocalPort();
                String string = IPC.getRandomString();
                reply = new Reply(this.portNumber, string, TargetDirectory.getTargetDirectoryPath((String)this.descriptor.id()), this.descriptor.getUid());
                try {
                    IPC.logMessage((String)"OpenJ9VirtualMachine.tryAttachTarget() before replyFile.writeReply()");
                    reply.writeReply();
                }
                catch (IOException iOException) {
                    AttachNotSupportedException attachNotSupportedException = new AttachNotSupportedException(Msg.getString((String)"K0457"));
                    attachNotSupportedException.initCause(iOException);
                    IPC.logMessage((String)"OpenJ9VirtualMachine.tryAttachTarget() Target no longer available.");
                    throw attachNotSupportedException;
                }
                if (this.descriptor.id().equals(AttachHandler.getVmId())) {
                    boolean bl;
                    String string2 = AttachHandler.allowAttachSelf;
                    boolean bl2 = bl = "".equals(string2) || Boolean.parseBoolean(string2);
                    if (!bl) {
                        throw new IOException(Msg.getString((String)"K0646"));
                    }
                    if (!AttachHandler.isAttachApiInitialized()) throw new AttachNotSupportedException(Msg.getString((String)"K0558"));
                    AttachHandler.getMainHandler().connectToAttacher();
                } else {
                    this.lockAllAttachNotificationSyncFiles(list);
                    n2 = CommonDirectory.countTargetDirectories();
                    int n5 = CommonDirectory.notifyVm((int)n2, (boolean)this.descriptor.isGlobalSemaphore(), (String)"OpenJ9VirtualMachine.tryAttachTarget");
                    if (0 != n5 && 103 != n5) {
                        throw new AttachNotSupportedException(Msg.getString((String)"K0532", (int)n5));
                    }
                }
                try {
                    IPC.logMessage((String)("attachTarget " + this.targetId + " on port " + this.portNumber));
                    this.targetServer.setSoTimeout(n);
                    this.targetSocket = this.targetServer.accept();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.targetServer.close();
                    IPC.logMessage((String)("attachTarget SocketTimeoutException on " + this.portNumber + " to " + this.targetId));
                    AttachNotSupportedException attachNotSupportedException = new AttachNotSupportedException(Msg.getString((String)"K0539", (Object)this.targetId, (Object)this.portNumber));
                    attachNotSupportedException.initCause(socketTimeoutException);
                    throw attachNotSupportedException;
                }
                this.commandStream = this.targetSocket.getOutputStream();
                this.targetSocket.setSoTimeout(COMMAND_TIMEOUT);
                this.responseStream = this.targetSocket.getInputStream();
                String string3 = AttachmentConnection.streamReceiveString((InputStream)this.responseStream, (int)4000);
                if (!string3.contains(' ' + string + ' ')) {
                    throw new AttachNotSupportedException(Msg.getString((String)"K0533", (Object)string3));
                }
                IPC.logMessage((String)"attachTarget connected on ", (String)this.portNumber.toString());
                this.targetAttached = true;
                if (null == reply) break block30;
                reply.deleteReply();
            }
            if (n2 > 0) {
                this.unlockAllAttachNotificationSyncFiles();
                CommonDirectory.cancelNotify((int)n2, (boolean)this.descriptor.isGlobalSemaphore());
                if (n2 > 2) {
                    try {
                        int n6 = 100 * (n2 > 10 ? 10 : n2);
                        IPC.logMessage((String)"attachTarget sleep for ", (int)n6);
                        Thread.sleep(n6);
                    }
                    catch (InterruptedException interruptedException) {
                        IPC.logMessage((String)"attachTarget sleep interrupted");
                    }
                }
            }
            CommonDirectory.releaseAttachLock((String)("OpenJ9VirtualMachine.tryAttachTarget(" + n + ")"));
            return;
        }
    }

    private void unlockAllAttachNotificationSyncFiles() {
        if (null != this.targetLocks) {
            for (int i = 0; i < this.targetLocks.length; ++i) {
                IPC.logMessage((String)"unlockAllAttachNotificationSyncFiles unlocking targetLocks[", (int)i, (String)"]");
                if (null == this.targetLocks[i]) continue;
                this.targetLocks[i].unlockFile("OpenJ9VirtualMachine.unlockAllAttachNotificationSyncFiles");
            }
        }
    }

    @Override
    public void startManagementAgent(Properties properties) throws IOException, IllegalArgumentException, AttachOperationFailedException {
        if (!this.targetAttached) {
            throw new IOException(Msg.getString((String)"K0544"));
        }
        if (null == properties) {
            throw new NullPointerException();
        }
        AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)"ATTACH_START_MANAGEMENT_AGENT");
        IPC.sendProperties((Properties)properties, (OutputStream)this.commandStream);
        String string = AttachmentConnection.streamReceiveString((InputStream)this.responseStream);
        try {
            OpenJ9VirtualMachine.parseResponse(string);
        }
        catch (AgentInitializationException | AgentLoadException exception) {
            IPC.logMessage((String)("Unexpected exception " + exception + " in startManagementAgent"));
        }
    }

    @Override
    public String startLocalManagementAgent() throws IOException {
        String string;
        block6: {
            if (!this.targetAttached) {
                throw new IOException(Msg.getString((String)"K0544"));
            }
            AttachmentConnection.streamSend((OutputStream)this.commandStream, (String)"ATTACH_START_LOCAL_MANAGEMENT_AGENT");
            String string2 = AttachmentConnection.streamReceiveString((InputStream)this.responseStream);
            string = "";
            try {
                if (!OpenJ9VirtualMachine.parseResponse(string2)) {
                    throw new IOException(Msg.getString((String)"k05dd", (Object)string2));
                }
                if (string2.startsWith("ATTACH_ACK")) {
                    string = string2.substring("ATTACH_ACK".length());
                    break block6;
                }
                if (string2.startsWith("ATTACH_RESULT=")) {
                    string = string2.substring("ATTACH_RESULT=".length());
                    break block6;
                }
                throw new IOException(Msg.getString((String)"k05dd", (Object)string2));
            }
            catch (AgentInitializationException | AgentLoadException | IllegalArgumentException exception) {
                IPC.logMessage((String)("Unexpected exception " + exception + " in startLocalManagementAgent"));
            }
        }
        return string;
    }

    public InputStream heapHisto(Object ... objectArray) {
        InputStream inputStream = null;
        PrivilegedExceptionAction<InputStream> privilegedExceptionAction = () -> this.heapHistoImpl(objectArray);
        try {
            inputStream = AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
        return inputStream;
    }

    private InputStream heapHistoImpl(Object ... objectArray) {
        String string = null;
        IPC.logMessage((String)"heapHisto called");
        boolean bl = true;
        for (Object object : objectArray) {
            IPC.logMessage((String)"heapHisto option: ", (String)object.toString());
            if ("-live".equals(object)) {
                bl = true;
                continue;
            }
            if ("-all".equals(object)) {
                bl = false;
                continue;
            }
            string = "unrecognized option: " + object.toString();
        }
        if (null == string) {
            String string2 = DiagnosticUtils.makeHeapHistoCommand((boolean)bl);
            try {
                DiagnosticProperties iOException = new DiagnosticProperties(this.executeDiagnosticCommand(string2));
                string = iOException.printStringResult();
            }
            catch (IOException iOException) {
                string = "Error executing heapHisto command: " + iOException.toString();
            }
        }
        IPC.logMessage((String)"heapHisto result: ", string);
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof VirtualMachine)) {
            return false;
        }
        VirtualMachine virtualMachine = (VirtualMachine)object;
        return this.id().equals(virtualMachine.id());
    }

    @Override
    public int hashCode() {
        return this.provider().hashCode() + this.id().hashCode();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + ";" + this.id();
    }

    static {
        PrivilegedAction<Object> privilegedAction = () -> {
            MAXIMUM_ATTACH_TIMEOUT = Integer.getInteger("com.ibm.tools.attach.timeout", 120000);
            COMMAND_TIMEOUT = Integer.getInteger("com.ibm.tools.attach.command_timeout", 0);
            return null;
        };
        AccessController.doPrivileged(privilegedAction);
    }
}

