/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import sun.tools.attach.HotSpotAttachProvider;
import sun.tools.attach.WindowsVirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsAttachProvider
extends HotSpotAttachProvider {
    private static final long FS_PERSISTENT_ACLS = 8L;
    private static volatile boolean wasTempPathChecked;
    private static boolean isTempPathSecure;
    private static volatile boolean isProcessStatusHelperInitialized;

    public WindowsAttachProvider() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows 9") || string.equals("Windows Me")) {
            throw new RuntimeException("This provider is not supported on this version of Windows");
        }
        String string2 = System.getProperty("os.arch");
        if (!string2.equals("x86") && !string2.equals("amd64")) {
            throw new RuntimeException("This provider is not supported on this processor architecture");
        }
    }

    @Override
    public String name() {
        return "sun";
    }

    @Override
    public String type() {
        return "windows";
    }

    @Override
    public VirtualMachine attachVirtualMachine(String string) throws AttachNotSupportedException, IOException {
        this.checkAttachPermission();
        this.testAttachable(string);
        return new WindowsVirtualMachine(this, string);
    }

    @Override
    public List<VirtualMachineDescriptor> listVirtualMachines() {
        if (WindowsAttachProvider.isTempPathSecure()) {
            return super.listVirtualMachines();
        }
        return this.listJavaProcesses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTempPathSecure() {
        if (wasTempPathChecked) return isTempPathSecure;
        Class<WindowsAttachProvider> clazz = WindowsAttachProvider.class;
        synchronized (WindowsAttachProvider.class) {
            if (wasTempPathChecked) return isTempPathSecure;
            String string = WindowsAttachProvider.tempPath();
            if (string != null && string.length() >= 3 && string.charAt(1) == ':' && string.charAt(2) == '\\') {
                long l = WindowsAttachProvider.volumeFlags(string.substring(0, 3));
                isTempPathSecure = (l & 8L) != 0L;
            }
            wasTempPathChecked = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return isTempPathSecure;
        }
    }

    private static native String tempPath();

    private static native long volumeFlags(String var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private List<VirtualMachineDescriptor> listJavaProcesses() {
        Object object;
        if (!isProcessStatusHelperInitialized) {
            object = WindowsAttachProvider.class;
            // MONITORENTER : sun.tools.attach.WindowsAttachProvider.class
            if (!isProcessStatusHelperInitialized) {
                WindowsAttachProvider.initializeProcessStatusHelper();
                isProcessStatusHelperInitialized = true;
            }
            // MONITOREXIT : object
        }
        object = new ArrayList();
        String string = "localhost";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        int[] nArray = new int[1024];
        int n = WindowsAttachProvider.enumProcesses(nArray, nArray.length);
        int n2 = 0;
        while (n2 < n) {
            if (WindowsAttachProvider.isLibraryLoadedByProcess("jvm.dll", nArray[n2])) {
                String string2 = Integer.toString(nArray[n2]);
                try {
                    new WindowsVirtualMachine(this, string2).detach();
                    String string3 = string2 + "@" + string;
                    ((ArrayList)object).add(new HotSpotAttachProvider.HotSpotVirtualMachineDescriptor(this, string2, string3));
                }
                catch (AttachNotSupportedException attachNotSupportedException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return object;
    }

    private static native void initializeProcessStatusHelper();

    private static native int enumProcesses(int[] var0, int var1);

    private static native boolean isLibraryLoadedByProcess(String var0, int var1);

    static {
        System.loadLibrary("attach");
    }
}

