/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.musl;

import com.yourkit.asserts.NotNull;
import com.yourkit.util.XmlUtil;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlBuilder {
    @NotNull
    private final StringWriter myWriter = new StringWriter();
    @NotNull
    private final StreamResult myResult = new StreamResult(this.myWriter);
    @NotNull
    private Transformer myTransformer = XmlUtil.newPrettyTransformer();

    @NotNull
    public static XmlBuilder newXmlBuilder() {
        return new XmlBuilder();
    }

    private XmlBuilder() {
    }

    @NotNull
    public XmlBuilder withXmlDeclaration(boolean withXmlDeclaration) {
        XmlUtil.withXmlDeclaration(this.myTransformer, withXmlDeclaration);
        XmlBuilder xmlBuilder = this;
        if (xmlBuilder == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder setTransformer(@NotNull Transformer transformer) {
        if (transformer == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myTransformer = transformer;
        XmlBuilder xmlBuilder = this;
        if (xmlBuilder == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder append(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        DOMSource source = new DOMSource(node);
        try {
            this.myTransformer.transform(source, this.myResult);
        }
        catch (TransformerException exc) {
            throw new RuntimeException(exc);
        }
        XmlBuilder xmlBuilder = this;
        if (xmlBuilder == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return xmlBuilder;
    }

    @NotNull
    public XmlBuilder appendChildren(@NotNull Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            this.append(children.item(i));
        }
        XmlBuilder xmlBuilder = this;
        if (xmlBuilder == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return xmlBuilder;
    }

    @NotNull
    public String toXml() {
        this.myWriter.flush();
        String string = this.myWriter.toString().trim();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public String toString() {
        return this.toXml();
    }
}

