/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.logging;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.ArrayUtil;
import com.yourkit.util.Properties;
import com.yourkit.util.logging.CallerClassNameRetriever;
import com.yourkit.util.logging.CallerClassNameRetrieverJava7Impl;
import com.yourkit.util.logging.LogHandler;
import com.yourkit.util.logging.LogLevel;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;

public final class Logger {
    @NotNull
    private final AtomicReference<LogHandler[]> myHandlers = new AtomicReference<LogHandler[]>(new LogHandler[0]);
    @NotNull
    private CallerClassNameRetriever myCallerClassNameRetriever = new CallerClassNameRetrieverJava7Impl();
    private boolean myVerbose = Properties.getBooleanProperty("yk.verbose", false);

    @NotNull
    public static Logger getLogger() {
        Logger logger = Holder.ourLogger;
        if (logger == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return logger;
    }

    public void reset() {
        LogHandler[] handlers;
        while ((handlers = this.getHandlers()).length != 0) {
            this.removeHandler(handlers[0]);
        }
        return;
    }

    @NotNull
    public LogHandler[] getHandlers() {
        LogHandler[] logHandlerArray = this.myHandlers.get();
        if (logHandlerArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return logHandlerArray;
    }

    public void addHandler(@NotNull LogHandler handler) {
        LogHandler[] newHandlers;
        LogHandler[] oldHandlers;
        if (handler == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        do {
            oldHandlers = this.myHandlers.get();
            int length = oldHandlers.length;
            newHandlers = new LogHandler[length + 1];
            System.arraycopy(oldHandlers, 0, newHandlers, 0, length);
            newHandlers[length] = handler;
        } while (!this.myHandlers.compareAndSet(oldHandlers, newHandlers));
    }

    public void removeHandler(@NotNull LogHandler handler) {
        LogHandler[] newHandlers;
        LogHandler[] oldHandlers;
        if (handler == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        do {
            if ((oldHandlers = this.myHandlers.get()).length == 0) {
                return;
            }
            int idx = ArrayUtil.linearSearch(oldHandlers, handler);
            if (idx < 0) {
                return;
            }
            int length = oldHandlers.length;
            newHandlers = new LogHandler[length - 1];
            System.arraycopy(oldHandlers, 0, newHandlers, 0, idx);
            System.arraycopy(oldHandlers, idx + 1, newHandlers, idx, length - idx - 1);
        } while (!this.myHandlers.compareAndSet(oldHandlers, newHandlers));
    }

    public void log(@NotNull LogLevel level, @NotNull String message, @Nullable Throwable throwable) {
        if (level == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        Date timestamp = new Date();
        for (LogHandler handler : this.myHandlers.get()) {
            handler.log(timestamp, level, message, throwable);
        }
    }

    public boolean isVerbose() {
        return this.myVerbose;
    }

    public void setVerbose(boolean verbose) {
        this.myVerbose = verbose;
    }

    @NotNull
    public CallerClassNameRetriever getCallerClassNameRetriever() {
        CallerClassNameRetriever callerClassNameRetriever = this.myCallerClassNameRetriever;
        if (callerClassNameRetriever == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return callerClassNameRetriever;
    }

    public void setCallerClassNameRetriever(@NotNull CallerClassNameRetriever retriever) {
        if (retriever == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myCallerClassNameRetriever = retriever;
    }

    public static void error(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Logger.error(message, null);
    }

    public static void error(@NotNull Throwable throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Logger.error("", throwable);
    }

    public static void error(@NotNull String message, @Nullable Throwable t) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Logger logger = Logger.getLogger();
        logger.log(LogLevel.ERROR, logger.getCaller() + ": " + message, t);
    }

    public static void warning(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Logger.warning(message, null);
    }

    public static void warning(@NotNull String message, @Nullable Throwable t) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Logger logger = Logger.getLogger();
        logger.log(LogLevel.WARNING, logger.getCaller() + ": " + message, t);
    }

    public static void message(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Logger.message(message, null);
    }

    public static void message(@NotNull Throwable throwable) {
        if (throwable == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Logger.message("", throwable);
    }

    public static void message(@NotNull String message, @Nullable Throwable e) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Logger logger = Logger.getLogger();
        logger.log(LogLevel.MESSAGE, logger.getCaller() + ": " + message, e);
    }

    @NotNull
    public String getCaller() {
        String loggerClassName = Logger.class.getName();
        String callerClassName = this.myCallerClassNameRetriever.getCallerClassName(loggerClassName);
        return callerClassName != null ? callerClassName : "<unknown caller>";
    }

    private static final class Holder {
        public static final Logger ourLogger = new Logger();

        private Holder() {
        }
    }
}

