/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.logging;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.Strings;
import com.yourkit.util.logging.LogLevel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class LogUtil {
    public static String format(@Nullable Date timestamp, @NotNull LogLevel level, @NotNull String message, @Nullable Throwable exc) {
        if (level == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        StringBuilder b = new StringBuilder();
        Strings.appendSeparated(b, (CharSequence)LogUtil.formatTimestamp(timestamp), " ");
        Strings.appendSeparated(b, (CharSequence)LogUtil.formatLevel(level), " ");
        Strings.appendSeparated(b, (CharSequence)message, " ");
        if (exc != null) {
            Strings.appendSeparated(b, (CharSequence)LogUtil.formatStackTrace(exc), ": ");
        }
        return b.toString();
    }

    @NotNull
    public static String formatTimestamp(@Nullable Date timestamp) {
        if (timestamp != null) {
            SimpleDateFormat format = new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss.SSS]", Locale.US);
            String string = format.format(timestamp);
            if (string == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return string;
        }
        return "";
    }

    @NotNull
    public static String formatLevel(@NotNull LogLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        switch (level) {
            case ERROR: {
                return "ERROR:";
            }
            case MESSAGE: {
                return "";
            }
            case WARNING: {
                return "WARNING:";
            }
        }
        throw new RuntimeException("Unknown level=" + (Object)((Object)level));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String formatMessage(@NotNull String msg, @Nullable Throwable e) {
        String string;
        if (msg == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (e == null) {
            string = msg;
            if (string == null) throw new IllegalStateException("Method must not return null");
            return string;
        }
        StringBuilder b = new StringBuilder(msg);
        Strings.appendSeparated(b, (CharSequence)LogUtil.formatStackTrace(e), ": ");
        string = b.toString();
        if (string != null) return string;
        throw new IllegalStateException("Method must not return null");
    }

    @NotNull
    public static String formatStackTrace(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        StringBuilder result = new StringBuilder();
        LogUtil.printStackTrace(result, e);
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void printStackTrace(@NotNull StringBuilder result, @NotNull StackTraceElement[] trace, int elementsToSkip) {
        if (result == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (trace == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        for (int i = elementsToSkip; i < trace.length; ++i) {
            result.append("\tat ");
            result.append(trace[i].toString());
            result.append('\n');
        }
    }

    public static void printStackTrace(@NotNull StringBuilder result, @NotNull Throwable e) {
        if (result == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        result.append(e);
        result.append('\n');
        StackTraceElement[] trace = e.getStackTrace();
        LogUtil.printStackTrace(result, trace, 0);
        Throwable cause = e.getCause();
        if (cause != null) {
            LogUtil.printStackTraceAsCause(result, cause, trace);
        }
    }

    private static void printStackTraceAsCause(@NotNull StringBuilder result, @NotNull Throwable e, @NotNull StackTraceElement[] causedTrace) {
        Throwable ourCause;
        if (result == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (e == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (causedTrace == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        StackTraceElement[] trace = e.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        result.append("Caused by: ");
        result.append(e);
        result.append('\n');
        for (int i = 0; i <= m; ++i) {
            result.append("\tat ");
            result.append(trace[i].toString());
            result.append('\n');
        }
        if (framesInCommon != 0) {
            result.append("\t... ");
            result.append(framesInCommon);
            result.append(" more");
            result.append('\n');
        }
        if ((ourCause = e.getCause()) != null) {
            LogUtil.printStackTraceAsCause(result, ourCause, trace);
        }
    }
}

