/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.logging;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.IoUtil;
import com.yourkit.util.logging.LogHandler;
import com.yourkit.util.logging.LogLevel;
import com.yourkit.util.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public final class FileLogHandler
implements LogHandler {
    @NotNull
    private final File myLogFile;

    public FileLogHandler(@NotNull File logFile) {
        if (logFile == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myLogFile = logFile;
    }

    @Override
    public void log(@NotNull Date timestamp, @NotNull LogLevel level, @NotNull String message, @Nullable Throwable exc) {
        if (timestamp == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        try {
            IoUtil.appendlnUtf8(this.myLogFile, LogUtil.format(timestamp, level, message, exc));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

