/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.http;

import com.yourkit.asserts.NotNull;

public enum HttpStatus {
    OK(200, "OK"),
    NO_CONTENT(204, "No Content"),
    MOVED(301, "Moved Permanently"),
    NOT_MODIFIED(304, "Not Modified"),
    BAD_REQUEST(400, "Bad Request"),
    NOT_FOUND(404, "Not Found"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    PAYLOAD_TOO_LARGE(413, "Payload Too Large"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
    NOT_IMPLEMENTED(501, "Not Implemented");

    public final int myCode;
    @NotNull
    public final String myReason;

    private HttpStatus(int code, String reason) {
        if (reason == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this.myCode = code;
        this.myReason = reason;
    }

    public String getStatusLine() {
        return this.myCode + " " + this.myReason;
    }
}

