/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit;

import com.yourkit.asserts.NotNull;
import com.yourkit.util.JavaVersion;
import com.yourkit.util.Os;
import com.yourkit.util.Properties;
import com.yourkit.util.Strings;
import java.io.File;

public final class Constants {
    public static final String SNAPSHOT_FILE_EXTENSION = ".snapshot";
    public static final String HPROF_FILE_EXTENSION = ".hprof";
    public static final String PHD_FILE_EXTENSION = ".phd";
    public static final String JFR_FILE_EXTENSION = ".jfr";
    public static final String JS_SNAPSHOT_FILE_EXTENSION = ".heapsnapshot";
    public static final String LOG_FILE_EXTENSION = ".log";
    public static final File USER_HOME_RAW = new File(Properties.user_home.valueNotNull());
    public static final File USER_HOME;
    public static final boolean CUSTOM_USER_HOME;
    public static final File SNAPSHOT_DIR;
    @NotNull
    public static final String OS;
    public static final boolean OS_LINUX;
    public static final boolean OS_MAC;
    public static final boolean OS_WINDOWS;
    @NotNull
    public static final String JAVA_VERSION;
    public static final int JAVA_VERSION_NUMBER;
    @NotNull
    public static final String LINE_SEPARATOR;
    public static final int DEFAULT_PORT_MIN = 10001;
    public static final int DEFAULT_PORT_MAX = 10010;
    public static final String DEFAULT_PORTS = "10001-10010";
    public static final String NATIVE_METHOD_PREFIX = "$$YJP$$";
    public static final long SNAPSHOT_WITH_HEAP = 1L;
    public static final long SNAPSHOT_HPROF = 16L;
    public static final int COLUMN_TYPE_INT = 0;
    public static final int COLUMN_TYPE_LONG = 1;
    public static final int COLUMN_TYPE_STRING = 2;
    public static final int COLUMN_TYPE_FOREIGN_KEY = 3;
    public static final int COLUMN_TYPE_CLASS_NAME = 4;
    public static final int COLUMN_TYPE_OBJECT = 5;
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_UPTIME_NS = "uptime_ns";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_UPTIME_NS_END = "uptime_ns.end";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_EXCEPTION_STR = "exception_str";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_THREAD = "thread";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_STACKTRACE = "frame";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_RESOURCE_OBJECT_ID = "resource_object_id";
    public static final String EVENT_TABLE_PREDEFINED_COLUMN_RESOURCE_OBJECT_CLASS = "Class";
    public static final int BYTES_IN_MB = 0x100000;
    public static final int UNDEFINED_LINE = 0;
    public static final String LISTEN_ALL = "all";
    public static final String LISTEN_LOCALHOST = "localhost";
    public static final boolean IS_IBM;
    public static final int MIN_SUPPORTED_JDK_VERSION = 8;
    public static final int MAX_SUPPORTED_JDK_VERSION = 25;

    static {
        String path = null;
        try {
            path = System.getenv("YOURKIT_HOME");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = CUSTOM_USER_HOME = !Strings.isNullOrEmpty(path);
        if (!CUSTOM_USER_HOME) {
            path = Properties.user_home.valueNotNull();
        }
        USER_HOME = new File(path);
        SNAPSHOT_DIR = OS_WINDOWS || CUSTOM_USER_HOME || USER_HOME.isDirectory() && USER_HOME.canWrite() ? new File(USER_HOME, "Snapshots") : new File("/tmp");
        OS = Properties.os_name.valueNotNull();
        OS_LINUX = Os.getCurrent().isLinux();
        OS_MAC = Os.getCurrent().isMac();
        OS_WINDOWS = Os.getCurrent().isWindows();
        JAVA_VERSION = Properties.java_version.valueNotNull();
        JAVA_VERSION_NUMBER = JavaVersion.getJavaVersion(JAVA_VERSION);
        LINE_SEPARATOR = OS_WINDOWS ? "\r\n" : "\n";
        String vmVendor = Properties.java_vm_vendor.value("");
        IS_IBM = vmVendor.contains("IBM") || vmVendor.contains("OpenJ9");
    }
}

