/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.probes;

import com.yourkit.asserts.Asserts;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;

public class WeakKeyMap<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final Object NULL_KEY = new Object();

    private Entry<K, V>[] newTable(int n) {
        return new Entry[n];
    }

    public WeakKeyMap(int initialCapacity, float loadFactor) {
        int capacity;
        initialCapacity = Asserts.requireNotNegative((int)Math.min(initialCapacity, 0x40000000));
        Asserts.requireFalse((loadFactor <= 0.0f || Float.isNaN(loadFactor) ? 1 : 0) != 0, (String)("Illegal Load factor: " + loadFactor));
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.table = this.newTable(capacity);
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public WeakKeyMap() {
        this(16, 0.75f);
    }

    private static int getHashCode(Object o) {
        return System.identityHashCode(o);
    }

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    private static boolean eq(Object x, Object y) {
        return x == y;
    }

    final int hash(Object k) {
        int h = WeakKeyMap.getHashCode(k);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<Object> x;
        while ((x = this.queue.poll()) != null) {
            ReferenceQueue<Object> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                Entry<K, V> prev;
                Entry e = (Entry)x;
                int i = WeakKeyMap.indexFor(e.hash, this.table.length);
                Entry<K, V> p = prev = this.table[i];
                while (p != null) {
                    Entry next = p.next;
                    if (p == e) {
                        if (prev == e) {
                            this.table[i] = next;
                        } else {
                            prev.next = next;
                        }
                        e.value = null;
                        --this.size;
                        break;
                    }
                    prev = p;
                    p = next;
                }
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public V get(Object key) {
        Object k = WeakKeyMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int index = WeakKeyMap.indexFor(h, tab.length);
        Entry<K, V> e = tab[index];
        while (e != null) {
            if (e.hash == h && WeakKeyMap.eq(k, e.get())) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    Entry<K, V> getEntry(Object key) {
        Object k = WeakKeyMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int index = WeakKeyMap.indexFor(h, tab.length);
        Entry<K, V> e = tab[index];
        while (!(e == null || e.hash == h && WeakKeyMap.eq(k, e.get()))) {
            e = e.next;
        }
        return e;
    }

    public V put(K key, V value) {
        Object k = WeakKeyMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int i = WeakKeyMap.indexFor(h, tab.length);
        Entry<K, V> e = tab[i];
        while (e != null) {
            if (h == e.hash && WeakKeyMap.eq(k, e.get())) {
                Object oldValue = e.value;
                if (value != oldValue) {
                    e.value = value;
                }
                return oldValue;
            }
            e = e.next;
        }
        e = tab[i];
        tab[i] = new Entry<K, V>(k, value, this.queue, h, e);
        if (++this.size >= this.threshold) {
            this.resize(tab.length * 2);
        }
        return null;
    }

    void resize(int newCapacity) {
        Entry<K, V>[] oldTable = this.getTable();
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry<K, V>[] newTable = this.newTable(newCapacity);
        this.transfer(oldTable, newTable);
        this.table = newTable;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable);
            this.table = oldTable;
        }
    }

    private void transfer(Entry<K, V>[] src, Entry<K, V>[] dest) {
        for (int j = 0; j < src.length; ++j) {
            Entry<K, V> e = src[j];
            src[j] = null;
            while (e != null) {
                Entry next = e.next;
                Object key = e.get();
                if (key == null) {
                    e.next = null;
                    e.value = null;
                    --this.size;
                } else {
                    int i = WeakKeyMap.indexFor(e.hash, dest.length);
                    e.next = dest[i];
                    dest[i] = e;
                }
                e = next;
            }
        }
    }

    public V remove(Object key) {
        Entry<K, V> prev;
        Object k = WeakKeyMap.maskNull(key);
        int h = this.hash(k);
        Entry<K, V>[] tab = this.getTable();
        int i = WeakKeyMap.indexFor(h, tab.length);
        Entry<K, V> e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == e.hash && WeakKeyMap.eq(k, e.get())) {
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    private static class Entry<K, V>
    extends WeakReference<Object>
    implements Map.Entry<K, V> {
        V value;
        final int hash;
        Entry<K, V> next;

        Entry(Object key, V value, ReferenceQueue<Object> queue, int hash, Entry<K, V> next) {
            super(key, queue);
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)WeakKeyMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return k1 == (k2 = e.getKey()) && (v1 = this.getValue()) == (v2 = e.getValue());
        }

        @Override
        public int hashCode() {
            K k = this.getKey();
            V v = this.getValue();
            return WeakKeyMap.getHashCode(k) ^ WeakKeyMap.getHashCode(v);
        }
    }
}

