/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.monitor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.jvmstat.monitor.HostIdentifier;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredVm;
import sun.jvmstat.monitor.VmIdentifier;
import sun.jvmstat.monitor.event.HostListener;

public abstract class MonitoredHost {
    private static Map monitoredHosts = new HashMap();
    private static final String IMPL_OVERRIDE_PROP_NAME = "sun.jvmstat.monitor.MonitoredHost";
    private static final String IMPL_PKG_PROP_NAME = "sun.jvmstat.monitor.package";
    private static final String IMPL_PACKAGE = System.getProperty("sun.jvmstat.monitor.package", "sun.jvmstat.perfdata");
    private static final String LOCAL_PROTOCOL_PROP_NAME = "sun.jvmstat.monitor.local";
    private static final String LOCAL_PROTOCOL = System.getProperty("sun.jvmstat.monitor.local", "local");
    private static final String REMOTE_PROTOCOL_PROP_NAME = "sun.jvmstat.monitor.remote";
    private static final String REMOTE_PROTOCOL = System.getProperty("sun.jvmstat.monitor.remote", "rmi");
    private static final String MONITORED_HOST_CLASS = "MonitoredHostProvider";
    protected HostIdentifier hostId;
    protected int interval;
    protected Exception lastException;

    public static MonitoredHost getMonitoredHost(String string) throws MonitorException, URISyntaxException {
        HostIdentifier hostIdentifier = new HostIdentifier(string);
        return MonitoredHost.getMonitoredHost(hostIdentifier);
    }

    public static MonitoredHost getMonitoredHost(VmIdentifier vmIdentifier) throws MonitorException {
        HostIdentifier hostIdentifier = new HostIdentifier(vmIdentifier);
        return MonitoredHost.getMonitoredHost(hostIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MonitoredHost getMonitoredHost(HostIdentifier hostIdentifier) throws MonitorException {
        String string = System.getProperty(IMPL_OVERRIDE_PROP_NAME);
        MonitoredHost monitoredHost = null;
        Object object = monitoredHosts;
        synchronized (object) {
            monitoredHost = (MonitoredHost)monitoredHosts.get(hostIdentifier);
            if (monitoredHost != null) {
                if (monitoredHost.isErrored()) {
                    monitoredHosts.remove(hostIdentifier);
                } else {
                    return monitoredHost;
                }
            }
        }
        hostIdentifier = MonitoredHost.resolveHostId(hostIdentifier);
        if (string == null) {
            string = IMPL_PACKAGE + ".monitor.protocol." + hostIdentifier.getScheme() + "." + MONITORED_HOST_CLASS;
        }
        try {
            object = Class.forName(string);
            Constructor constructor = ((Class)object).getConstructor(hostIdentifier.getClass());
            monitoredHost = (MonitoredHost)constructor.newInstance(hostIdentifier);
            Map map = monitoredHosts;
            synchronized (map) {
                monitoredHosts.put(monitoredHost.hostId, monitoredHost);
            }
            return monitoredHost;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Could not find " + string + ": " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("Expected constructor missing in " + string + ": " + noSuchMethodException.getMessage(), noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Unexpected constructor access in " + string + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(string + "is abstract: " + instantiationException.getMessage(), instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof MonitorException) {
                throw (MonitorException)throwable;
            }
            throw new RuntimeException("Unexpected exception", invocationTargetException);
        }
    }

    protected static HostIdentifier resolveHostId(HostIdentifier hostIdentifier) throws MonitorException {
        String string = hostIdentifier.getHost();
        String string2 = hostIdentifier.getScheme();
        StringBuffer stringBuffer = new StringBuffer();
        assert (string != null);
        if (string2 == null) {
            string2 = string.compareTo("localhost") == 0 ? LOCAL_PROTOCOL : REMOTE_PROTOCOL;
        }
        stringBuffer.append(string2).append(":").append(hostIdentifier.getSchemeSpecificPart());
        String string3 = hostIdentifier.getFragment();
        if (string3 != null) {
            stringBuffer.append("#").append(string3);
        }
        try {
            return new HostIdentifier(stringBuffer.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            assert (false);
            throw new IllegalArgumentException("Malformed URI created: " + stringBuffer.toString());
        }
    }

    public HostIdentifier getHostIdentifier() {
        return this.hostId;
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setLastException(Exception exception) {
        this.lastException = exception;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void clearLastException() {
        this.lastException = null;
    }

    public boolean isErrored() {
        return this.lastException != null;
    }

    public abstract MonitoredVm getMonitoredVm(VmIdentifier var1) throws MonitorException;

    public abstract MonitoredVm getMonitoredVm(VmIdentifier var1, int var2) throws MonitorException;

    public abstract void detach(MonitoredVm var1) throws MonitorException;

    public abstract void addHostListener(HostListener var1) throws MonitorException;

    public abstract void removeHostListener(HostListener var1) throws MonitorException;

    public abstract Set activeVms() throws MonitorException;
}

