/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.tools;

import java.io.IOException;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.internal.tools.attach.target.IPC;
import openj9.tools.attach.diagnostics.attacher.AttacherDiagnosticsProvider;
import openj9.tools.attach.diagnostics.tools.Util;

public class Jstat {
    private static String vmid;
    private static String statOption;
    private static final String OPTION_CLASS = "-class";
    private static final String[] OPTIONS;
    private static final String ERROR_AN_ARG_REQUIRED = "An argument is required";
    private static final String ERROR_INVALID_ARG = "An invalid argument";
    private static final String ERROR_INVALID_OPTION = "An invalid option";
    private static final String ERROR_INVALID_VMID = "Can't monitor this utility JVM itself: ";
    private static final String ERROR_NOT_EXIST_VMID = "No such process for vmid: ";
    private static final String ERROR_OPTION_REQUIRED = "An <option> is required";
    private static final String ERROR_VMID_REQUIRED = "A <vmid> is required";
    private static String HELPTEXT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (Jstat.parseArguments(stringArray)) {
            if (vmid == null || vmid.isEmpty()) {
                Util.exitJVMWithReasonAndHelp(ERROR_VMID_REQUIRED, HELPTEXT);
            }
            AttacherDiagnosticsProvider attacherDiagnosticsProvider = new AttacherDiagnosticsProvider();
            String string = AttachHandler.getVmId();
            if (vmid.equals(string)) {
                Util.exitJVMWithReasonAndHelp(ERROR_INVALID_VMID + vmid, HELPTEXT);
            }
            if (vmid.matches("\\d+") && !IPC.processExists((long)Long.parseLong(vmid))) {
                Util.exitJVMWithReasonAndHelp(ERROR_NOT_EXIST_VMID + vmid, HELPTEXT);
            }
            try {
                attacherDiagnosticsProvider.attach(vmid);
                Util.runCommandAndPrintResult(attacherDiagnosticsProvider, statOption, "jstat");
            }
            catch (Exception exception) {
                System.err.printf("Error getting data from %s", vmid);
                String string2 = exception.getMessage();
                if (string2 == null) {
                    System.err.println();
                } else if (string2.matches("OPENJ9_INCOMPATIBLE_JAVA_VERSION")) {
                    System.err.println(": incompatible target JVM");
                } else {
                    System.err.printf(": %s%n", string2);
                }
                if (DiagnosticProperties.isDebug) {
                    exception.printStackTrace();
                }
            }
            finally {
                try {
                    attacherDiagnosticsProvider.detach();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean parseArguments(String[] stringArray) {
        boolean bl = false;
        if (stringArray == null || stringArray.length == 0) {
            Util.exitJVMWithReasonAndHelp(ERROR_AN_ARG_REQUIRED, HELPTEXT);
        } else if (Util.checkHelpOption(stringArray[0])) {
            System.out.printf(HELPTEXT, new Object[0]);
        } else if ("-options".equals(stringArray[0])) {
            if (stringArray.length > 1) {
                Util.exitJVMWithReasonAndHelp(ERROR_INVALID_ARG, HELPTEXT);
            }
            for (String string : OPTIONS) {
                System.out.println(string);
            }
        } else {
            for (String string : stringArray) {
                if (string.startsWith("-")) {
                    if (statOption != null) {
                        Util.exitJVMWithReasonAndHelp(ERROR_INVALID_ARG, HELPTEXT);
                        continue;
                    }
                    bl = true;
                    switch (string) {
                        case "-class": {
                            statOption = "jstat.class";
                            break;
                        }
                        default: {
                            Util.exitJVMWithReasonAndHelp(ERROR_INVALID_OPTION, HELPTEXT);
                            break;
                        }
                    }
                    continue;
                }
                if (statOption == null) {
                    Util.exitJVMWithReasonAndHelp(ERROR_OPTION_REQUIRED, HELPTEXT);
                    continue;
                }
                if (vmid != null) {
                    Util.exitJVMWithReasonAndHelp(ERROR_INVALID_ARG, HELPTEXT);
                    continue;
                }
                vmid = string;
            }
        }
        return bl;
    }

    static {
        OPTIONS = new String[]{OPTION_CLASS};
        HELPTEXT = "jstat: obtain statistics information about a Java process%n Usage:%n    jstat [<option>] [<vmid>]%n%n  option:%n   -J : supply arguments to the Java VM running jstat%n   -h : print this help message%n   -options : list the available command options%n   -class : Classloading statistics%n  <vmid>: Attach API VM ID as shown in jps or other Attach API-based tools%nNOTE: this utility might significantly affect the performance of the target VM.%nAt least one option must be selected.%n";
    }
}

