/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.tools;

import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.util.List;
import openj9.tools.attach.diagnostics.tools.Util;

public class Jps {
    private static final String DESCRIPTION = "jps: Print a list of Java processes and information about them%n%n";
    private static final String HELP_TEXT = "Usage:%n    jps [-h] [-J<vm option>] [-l] [-q] [-m] [-v]%n    jps [-h] [-J<vm option>] [-q] [-lmv]%n%n    -h: print jps usage help%n    -J: supply arguments to the Java VM running jps%n    -l: print the application package name%n    -q: print only the virtual machine identifiers%n    -m: print the application arguments%n    -v: print the Java VM arguments, including those produced automatically%n";
    private static boolean printApplicationArguments;
    private static boolean printJvmArguments;
    private static boolean noPackageName;
    private static boolean vmidOnly;

    public static void main(String[] stringArray) {
        int n = 0;
        Jps.parseArguments(stringArray);
        List<AttachProvider> list = AttachProvider.providers();
        AttachProvider attachProvider = null;
        if (0 != list.size()) {
            attachProvider = list.get(0);
        }
        if (null == attachProvider) {
            System.err.println("no attach providers available");
            n = 1;
        } else {
            List<VirtualMachineDescriptor> list2 = attachProvider.listVirtualMachines();
            for (VirtualMachineDescriptor virtualMachineDescriptor : list2) {
                StringBuilder stringBuilder = new StringBuilder(virtualMachineDescriptor.id());
                if (!vmidOnly) {
                    Util.getTargetInformation(attachProvider, virtualMachineDescriptor, printJvmArguments, noPackageName, printApplicationArguments, stringBuilder);
                }
                System.out.println(stringBuilder.toString());
            }
        }
        System.exit(n);
    }

    private static void parseArguments(String[] stringArray) {
        printApplicationArguments = false;
        printJvmArguments = false;
        noPackageName = true;
        vmidOnly = false;
        for (String string : stringArray) {
            if (Jps.isInvalidArgument(string)) {
                System.out.printf("illegal argument: %s%n%n", string);
                Jps.interruptWithHelpMessage();
            }
            string = string.substring(1);
            for (char c : string.toCharArray()) {
                Jps.processArgument(c);
            }
        }
    }

    private static boolean isInvalidArgument(String string) {
        return !string.startsWith("-") || string.length() == 1 || string.contains("q") && string.length() > 2;
    }

    private static void processArgument(char c) {
        switch (c) {
            case 'l': {
                noPackageName = false;
                break;
            }
            case 'm': {
                printApplicationArguments = true;
                break;
            }
            case 'q': {
                vmidOnly = true;
                break;
            }
            case 'v': {
                printJvmArguments = true;
                break;
            }
            case 'h': {
                System.out.printf(DESCRIPTION, new Object[0]);
                Jps.interruptWithHelpMessage();
                break;
            }
            default: {
                System.out.printf("illegal argument: -%c%n%n", Character.valueOf(c));
                Jps.interruptWithHelpMessage();
            }
        }
    }

    private static void interruptWithHelpMessage() {
        System.out.printf(HELP_TEXT, new Object[0]);
        System.exit(1);
    }
}

