/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.http;

import com.yourkit.asserts.NotNull;

public final class HttpUriPathBuilder {
    private boolean myWithLeadingSlash;
    private boolean myWithTrailingSlash;
    @NotNull
    private final StringBuilder myPath = new StringBuilder();

    private HttpUriPathBuilder() {
    }

    @NotNull
    public static HttpUriPathBuilder newBuilder() {
        return new HttpUriPathBuilder();
    }

    @NotNull
    public HttpUriPathBuilder withLeadingSlash(boolean with) {
        this.myWithLeadingSlash = with;
        HttpUriPathBuilder httpUriPathBuilder = this;
        if (httpUriPathBuilder == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return httpUriPathBuilder;
    }

    @NotNull
    public HttpUriPathBuilder withTrailingSlash(boolean with) {
        this.myWithTrailingSlash = with;
        HttpUriPathBuilder httpUriPathBuilder = this;
        if (httpUriPathBuilder == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return httpUriPathBuilder;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public HttpUriPathBuilder append(@NotNull String fragment) {
        HttpUriPathBuilder httpUriPathBuilder;
        if (fragment == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (fragment.isEmpty()) {
            httpUriPathBuilder = this;
            if (httpUriPathBuilder == null) throw new IllegalStateException("Method must not return null");
            return httpUriPathBuilder;
        }
        int len = this.myPath.length();
        if (len == 0) {
            this.myPath.append(fragment);
            httpUriPathBuilder = this;
            if (httpUriPathBuilder == null) throw new IllegalStateException("Method must not return null");
            return httpUriPathBuilder;
        }
        if (this.myPath.charAt(len - 1) != '/') {
            this.myPath.append('/');
        }
        if (fragment.charAt(0) != '/') {
            this.myPath.append(fragment);
        } else {
            this.myPath.append(fragment.substring(1));
        }
        if ((httpUriPathBuilder = this) != null) return httpUriPathBuilder;
        throw new IllegalStateException("Method must not return null");
    }

    @NotNull
    public String build() {
        boolean hasTrailingSlash;
        boolean hasLeadingSlash;
        StringBuilder b = new StringBuilder(this.myPath.length() + 2);
        boolean bl = hasLeadingSlash = this.myPath.length() > 0 && this.myPath.charAt(0) == '/';
        if (this.myWithLeadingSlash && !hasLeadingSlash) {
            b.append('/');
        }
        b.append((CharSequence)this.myPath);
        boolean bl2 = hasTrailingSlash = b.length() > 0 && b.charAt(b.length() - 1) == '/';
        if (this.myWithTrailingSlash && !hasTrailingSlash) {
            b.append('/');
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }
}

