/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.IoUtil;
import com.yourkit.util.XmlElementIterator;
import com.yourkit.util.musl.XmlBuilder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XmlUtil {
    @NotNull
    public static Document parseFile(@NotNull File file) throws IOException {
        Document document;
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Throwable throwable = null;
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            Document document2 = XmlUtil.newDocumentBuilder().parse(stream);
            document = document2;
        }
        catch (SAXException exc) {
            try {
                throw new IOException("Cannot parse XML; file=" + file.getAbsolutePath(), exc);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (document == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return document;
    }

    @NotNull
    public static Document parse(@NotNull InputStream stream) throws IOException {
        Document document;
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        try {
            document = XmlUtil.newDocumentBuilder().parse(stream);
        }
        catch (SAXException exc) {
            throw new IOException("Cannot parse stream", exc);
        }
        if (document == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return document;
    }

    @NotNull
    public static String toXml(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = XmlBuilder.newXmlBuilder().append(document).toXml();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static void writeXmlFile(@NotNull Document document, @NotNull File file) throws IOException {
        if (document == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String xml = XmlBuilder.newXmlBuilder().withXmlDeclaration(true).append(document).toXml();
        IoUtil.writeUtf8(file, xml);
    }

    @NotNull
    public static Document newDocument() {
        Document document = XmlUtil.newDocumentBuilder().newDocument();
        if (document == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return document;
    }

    @NotNull
    public static Element newRootElement(@NotNull String rootElementName) {
        if (rootElementName == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Document document = XmlUtil.newDocumentBuilder().newDocument();
        Element rootElement = document.createElement(rootElementName);
        document.appendChild(rootElement);
        Element element = rootElement;
        if (element == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return element;
    }

    @NotNull
    public static DocumentBuilder newDocumentBuilder() {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException exc) {
            throw new RuntimeException(exc);
        }
        if (documentBuilder == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return documentBuilder;
    }

    @NotNull
    public static Transformer newIdentityTransformer() {
        Transformer transformer;
        try {
            Transformer transformer2 = TransformerFactory.newInstance().newTransformer();
            XmlUtil.withXmlDeclaration(transformer2, false);
            transformer = transformer2;
        }
        catch (TransformerConfigurationException exc) {
            throw new RuntimeException(exc);
        }
        if (transformer == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return transformer;
    }

    @NotNull
    public static Transformer newPrettyTransformer() {
        Transformer transformer;
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("indent-number", 2);
        try {
            transformer = factory.newTransformer();
        }
        catch (TransformerConfigurationException exc) {
            throw new RuntimeException(exc);
        }
        transformer.setOutputProperty("indent", "yes");
        XmlUtil.withXmlDeclaration(transformer, false);
        Transformer transformer2 = transformer;
        if (transformer2 == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return transformer2;
    }

    public static void withXmlDeclaration(@NotNull Transformer transformer, boolean withXmlDeclaration) {
        if (transformer == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        transformer.setOutputProperty("omit-xml-declaration", withXmlDeclaration ? "no" : "yes");
    }

    @NotNull
    public static String childrenToXml(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = XmlUtil.childrenToXml(element, XmlUtil.newIdentityTransformer());
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String childrenToPrettyXml(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String string = XmlUtil.childrenToXml(element, XmlUtil.newPrettyTransformer());
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    private static String childrenToXml(@NotNull Element element, @NotNull Transformer transformer) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (transformer == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        XmlBuilder b = XmlBuilder.newXmlBuilder().setTransformer(transformer);
        String string = b.appendChildren(element).toXml().trim();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @Nullable
    public static Element getChild(@NotNull Element element, @NotNull String tagName) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (tagName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        XmlElementIterator iterator = new XmlElementIterator(element, tagName);
        return iterator.hasNext() ? iterator.next() : null;
    }

    @NotNull
    public static List<Element> getChildren(@NotNull Element element, @NotNull String tagName) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (tagName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element e : new XmlElementIterator(element, tagName)) {
            result.add(e);
        }
        ArrayList<Element> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return arrayList;
    }

    public static boolean getBooleanAttribute(@NotNull Element element, @NotNull String attributeName, boolean defaultValue) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        Attr node = element.getAttributeNode(attributeName);
        if (node == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(node.getValue().trim());
    }

    public static int getIntAttribute(@NotNull Element element, @NotNull String attributeName, int defaultValue) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        Attr node = element.getAttributeNode(attributeName);
        if (node == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(node.getValue().trim(), 10);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    @NotNull
    public static String getRequiredString(@NotNull Element element, @NotNull String attributeName) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String value = XmlUtil.getOptionalString(element, attributeName);
        if (value == null) {
            throw new RuntimeException("attribute required: " + attributeName);
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @Nullable
    public static String getOptionalString(@NotNull Element element, @NotNull String attributeName) {
        if (element == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (attributeName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        Attr node = element.getAttributeNode(attributeName);
        if (node != null) {
            return node.getValue().trim();
        }
        return null;
    }
}

