/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.probes;

import com.yourkit.asserts.Asserts;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.probes.CallStatus;
import com.yourkit.probes.ClassNameColumn;
import com.yourkit.probes.Column;
import com.yourkit.probes.ForeignKeyColumn;
import com.yourkit.probes.IntColumn;
import com.yourkit.probes.LongColumn;
import com.yourkit.probes.ObjectColumn;
import com.yourkit.probes.ProbeConstants;
import com.yourkit.probes.ReflectionUtil;
import com.yourkit.probes.StringColumn;
import com.yourkit.runtime.AgentNatives;
import java.lang.reflect.Field;

public class Table {
    public static final long LASTING_EVENTS = 1L;
    public static final long RECORD_THREAD = 32L;
    public static final long RECORD_STACK_TRACE = 128L;
    public static final long MASK_FOR_POINT_EVENTS = 160L;
    public static final long MASK_FOR_LASTING_EVENTS = 161L;
    public static final int NO_ROW = 0;
    @NotNull
    final Class<?> myProbeClass;
    private final long myMask;
    private final String myName;
    private int myIndex;
    protected ForeignKeyColumn myFKColumn;

    public static boolean shouldIgnoreRow(int row) {
        return ProbeConstants.shouldIgnoreRow((int)row);
    }

    protected Table(@NotNull Class<?> probeClass, @NotNull String tableName, long mask) {
        if (probeClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this(probeClass, null, tableName, mask);
    }

    protected Table(@NotNull Table masterTable, @NotNull String tableName, long mask) {
        if (masterTable == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this(masterTable.myProbeClass, masterTable, tableName, mask);
    }

    private Table(@NotNull Class<?> probeClass, @Nullable Table masterTable, @NotNull String tableName, long mask) {
        if (probeClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        this.myProbeClass = probeClass;
        if (masterTable != null) {
            this.myFKColumn = new ForeignKeyColumn(masterTable);
        }
        this.myMask = mask;
        this.myName = Asserts.requireNotEmpty((String)tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCreated() {
        if (this.myIndex != 0) {
            return;
        }
        Table table = this;
        synchronized (table) {
            Column column2;
            if (this.myIndex != 0) {
                return;
            }
            Field[] fields = this.getClass().getDeclaredFields();
            Column[] columnsTmp = new Column[fields.length + 1];
            int ptr = 0;
            if (this.myFKColumn != null) {
                columnsTmp[ptr++] = this.myFKColumn;
            }
            for (Field field : fields) {
                if (!Column.class.isAssignableFrom(field.getType())) continue;
                CallStatus callStatus = new CallStatus();
                column2 = (Column)ReflectionUtil.getFieldValue(this.getClass(), this, field.getName(), callStatus);
                if (callStatus.failed()) {
                    throw new RuntimeException(callStatus.toString());
                }
                if (column2 == null) {
                    if (this.acceptNullColumns()) continue;
                    throw new RuntimeException("field must not be null: " + field.getName());
                }
                if ((field.getModifiers() & 8) != 0) {
                    throw new RuntimeException("column field must not be static: " + field.getName());
                }
                if (!(column2 instanceof IntColumn || column2 instanceof LongColumn || column2 instanceof StringColumn || column2 instanceof ClassNameColumn || column2 instanceof ObjectColumn || column2 instanceof ForeignKeyColumn)) {
                    throw new RuntimeException("unsupported column class: " + column2.getClass() + "; " + Column.class.getName() + " must not be subclassed by user");
                }
                if (column2 instanceof ForeignKeyColumn) {
                    if (this.myFKColumn != null) {
                        throw new RuntimeException("table can have only one column of class " + column2.getClass().getName());
                    }
                    this.myFKColumn = (ForeignKeyColumn)column2;
                }
                columnsTmp[ptr++] = column2;
            }
            Column[] columns = new Column[ptr];
            System.arraycopy(columnsTmp, 0, columns, 0, ptr);
            ColumnNameArrayList addedColumns = new ColumnNameArrayList();
            StringBuilder columnsDescription = new StringBuilder();
            boolean lastingEvents = Table.checkBit(this.myMask, 1L);
            Table.addColumn("uptime_ns", 1, addedColumns, columnsDescription);
            if (lastingEvents) {
                Table.addColumn("uptime_ns.end", 1, addedColumns, columnsDescription);
                Table.addColumn("exception_str", 2, addedColumns, columnsDescription);
            }
            if (Table.checkBit(this.myMask, 32L)) {
                Table.addColumn("thread", 0, addedColumns, columnsDescription);
            }
            if (Table.checkBit(this.myMask, 128L)) {
                Table.addColumn("frame", 0, addedColumns, columnsDescription);
            }
            int firstUserColumnIndex = addedColumns.getSize();
            for (Column column2 : columns) {
                Table.addColumn(column2.getName(), column2.getTypeID(), addedColumns, columnsDescription);
            }
            String tableDescription = this.myName + "\n" + addedColumns.getSize() + "\n" + columnsDescription;
            int tableIndex = AgentNatives.createEventTable((String)this.myProbeClass.getName(), (String)tableDescription);
            if (tableIndex == -1) {
                throw new RuntimeException("table creation failed");
            }
            for (int i = 0; i < columns.length; ++i) {
                column2 = columns[i];
                column2.assignToTable(tableIndex, i + firstUserColumnIndex);
            }
            this.myIndex = tableIndex;
        }
    }

    protected boolean acceptNullColumns() {
        return false;
    }

    public final int createRow() {
        this.ensureCreated();
        return AgentNatives.createEventTableRow((int)this.myIndex);
    }

    public final int createRow(int foreignKey) {
        this.ensureCreated();
        if (this.myFKColumn == null) {
            throw new RuntimeException("cannot call createRow(int) for a table without " + ForeignKeyColumn.class.getName() + " column");
        }
        if (Table.shouldIgnoreRow(foreignKey)) {
            return 0;
        }
        int row = this.createRow();
        this.myFKColumn.setValue(row, foreignKey);
        return row;
    }

    public final void closeRow(int row, @Nullable Throwable exception) {
        if (Table.shouldIgnoreRow(row)) {
            return;
        }
        String exceptionStr = exception == null ? null : exception.getClass().getName() + ": " + exception.getMessage();
        this.ensureCreated();
        AgentNatives.closeEventTableRow((int)this.myIndex, (int)row, (boolean)false, exceptionStr);
    }

    public final void setEventTableRowException(int row, @Nullable Throwable exception) {
        if (Table.shouldIgnoreRow(row)) {
            return;
        }
        String exceptionStr = exception == null ? null : exception.getClass().getName() + ": " + exception.getMessage();
        this.ensureCreated();
        AgentNatives.closeEventTableRow((int)this.myIndex, (int)row, (boolean)true, exceptionStr);
    }

    public final void setMinimumRecordedLastingEventTime(int wallTimeMs) {
        this.ensureCreated();
        AgentNatives.setMinimumRecordedLastingEventTime((int)this.myIndex, (int)wallTimeMs);
    }

    private static void addColumn(String name, int columnType, ColumnNameArrayList addedColumns, StringBuilder columnsDescription) {
        addedColumns.add(name);
        columnsDescription.append(name);
        columnsDescription.append('\n');
        columnsDescription.append(columnType);
        columnsDescription.append('\n');
    }

    private static boolean checkBit(long a, long b) {
        return (a & b) != 0L;
    }

    final int getIndex() {
        this.ensureCreated();
        return this.myIndex;
    }

    public void deleteRow(int rowIndex) {
        if (Table.shouldIgnoreRow(rowIndex)) {
            return;
        }
        this.ensureCreated();
        AgentNatives.deleteEventTableRow((int)this.myIndex, (int)rowIndex);
    }

    private static final class ColumnNameArrayList {
        private final String[] myArray = new String[128];
        private int mySize;

        public void add(String name) {
            for (int i = 0; i < this.mySize; ++i) {
                if (!name.equals(this.myArray[i])) continue;
                throw new RuntimeException("column with this name already exists: " + name);
            }
            if (this.mySize == this.myArray.length) {
                throw new RuntimeException("too many columns");
            }
            this.myArray[this.mySize++] = name;
        }

        public int getSize() {
            return this.mySize;
        }
    }
}

