/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.attach;

import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.AttachOperationFailedException;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import sun.tools.attach.HotSpotVirtualMachine;

public class BsdVirtualMachine
extends HotSpotVirtualMachine {
    private static final String tmpdir;
    String path;
    private static final String PROTOCOL_VERSION = "1";
    private static final int ATTACH_ERROR_BADVERSION = 101;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BsdVirtualMachine(AttachProvider attachProvider, String string) throws AttachNotSupportedException, IOException {
        super(attachProvider, string);
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AttachNotSupportedException("Invalid process identifier");
        }
        this.path = this.findSocketFile(n);
        if (this.path == null) {
            File file = new File(tmpdir, ".attach_pid" + n);
            BsdVirtualMachine.createAttachFile(file.getPath());
            try {
                BsdVirtualMachine.sendQuitTo(n);
                int n2 = 0;
                long l = 200L;
                int n3 = (int)(this.attachTimeout() / l);
                do {
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.path = this.findSocketFile(n);
                } while (++n2 <= n3 && this.path == null);
                if (this.path == null) {
                    throw new AttachNotSupportedException("Unable to open socket file: target process not responding or HotSpot VM not loaded");
                }
            }
            finally {
                file.delete();
            }
        }
        BsdVirtualMachine.checkPermissions(this.path);
        int n4 = BsdVirtualMachine.socket();
        try {
            BsdVirtualMachine.connect(n4, this.path);
        }
        finally {
            BsdVirtualMachine.close(n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach() throws IOException {
        BsdVirtualMachine bsdVirtualMachine = this;
        synchronized (bsdVirtualMachine) {
            if (this.path != null) {
                this.path = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    InputStream execute(String string, Object ... objectArray) throws AgentLoadException, IOException {
        int n;
        String string2;
        assert (objectArray.length <= 3);
        BsdVirtualMachine bsdVirtualMachine = this;
        synchronized (bsdVirtualMachine) {
            if (this.path == null) {
                throw new IOException("Detached from target VM");
            }
            string2 = this.path;
        }
        int n2 = BsdVirtualMachine.socket();
        try {
            BsdVirtualMachine.connect(n2, string2);
        }
        catch (IOException iOException) {
            BsdVirtualMachine.close(n2);
            throw iOException;
        }
        IOException iOException = null;
        try {
            this.writeString(n2, PROTOCOL_VERSION);
            this.writeString(n2, string);
            for (int i = 0; i < 3; ++i) {
                if (i < objectArray.length && objectArray[i] != null) {
                    this.writeString(n2, (String)objectArray[i]);
                    continue;
                }
                this.writeString(n2, "");
            }
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        SocketInputStream socketInputStream = new SocketInputStream(n2);
        try {
            n = this.readInt(socketInputStream);
        }
        catch (IOException iOException3) {
            socketInputStream.close();
            if (iOException != null) {
                throw iOException;
            }
            throw iOException3;
        }
        if (n != 0) {
            String string3 = this.readErrorMessage(socketInputStream);
            socketInputStream.close();
            if (n == 101) {
                throw new IOException("Protocol mismatch with target VM");
            }
            if (string.equals("load")) {
                throw new AgentLoadException("Failed to load agent library");
            }
            if (string3 == null) {
                throw new AttachOperationFailedException("Command failed in target VM");
            }
            throw new AttachOperationFailedException(string3);
        }
        return socketInputStream;
    }

    private String findSocketFile(int n) {
        String string = ".java_pid" + n;
        File file = new File(tmpdir, string);
        return file.exists() ? file.getPath() : null;
    }

    private void writeString(int n, String string) throws IOException {
        byte[] byArray;
        if (string.length() > 0) {
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError();
            }
            BsdVirtualMachine.write(n, byArray, 0, byArray.length);
        }
        byArray = new byte[]{0};
        BsdVirtualMachine.write(n, byArray, 0, 1);
    }

    static native void sendQuitTo(int var0) throws IOException;

    static native void checkPermissions(String var0) throws IOException;

    static native int socket() throws IOException;

    static native void connect(int var0, String var1) throws IOException;

    static native void close(int var0) throws IOException;

    static native int read(int var0, byte[] var1, int var2, int var3) throws IOException;

    static native void write(int var0, byte[] var1, int var2, int var3) throws IOException;

    static native void createAttachFile(String var0);

    static native String getTempDir();

    static {
        System.loadLibrary("attach");
        tmpdir = BsdVirtualMachine.getTempDir();
    }

    private class SocketInputStream
    extends InputStream {
        int s;

        public SocketInputStream(int n) {
            this.s = n;
        }

        @Override
        public synchronized int read() throws IOException {
            byte[] byArray = new byte[1];
            int n = this.read(byArray, 0, 1);
            if (n == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            return BsdVirtualMachine.read(this.s, byArray, n, n2);
        }

        @Override
        public void close() throws IOException {
            BsdVirtualMachine.close(this.s);
        }
    }
}

