/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.yourkit.asserts.NotNull;
import com.yourkit.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class FileTypeAdapter
extends TypeAdapter<File> {
    @NotNull
    private final ParsingPolicy myParsingPolicy;

    public FileTypeAdapter(@NotNull ParsingPolicy parsingPolicy) {
        if (parsingPolicy == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myParsingPolicy = parsingPolicy;
    }

    @Override
    public File read(JsonReader reader) {
        String path = Streams.parse(reader).getAsString();
        File file = FileUtil.expandAsFile(path);
        if (this.myParsingPolicy == ParsingPolicy.STRICT && !file.exists()) {
            throw new RuntimeException("File does not exist; path=" + path + "; file=" + file);
        }
        return file;
    }

    @Override
    public void write(JsonWriter out, File file) throws IOException {
        throw new UnsupportedEncodingException();
    }

    public static enum ParsingPolicy {
        RELAXED,
        STRICT;

    }
}

