/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.Nullable;

public class UnexpectedValueException
extends RuntimeException {
    public UnexpectedValueException(@Nullable Object value) {
        super("unexpected value: " + UnexpectedValueException.getPresentableText(value));
    }

    public UnexpectedValueException(@Nullable Object value1, @Nullable Object value2) {
        super("unexpected values:\nvalue1: " + UnexpectedValueException.getPresentableText(value1) + "\nvalue2: " + UnexpectedValueException.getPresentableText(value2));
    }

    public UnexpectedValueException(long value) {
        super("unexpected value: " + value);
    }

    private static String getPresentableText(@Nullable Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Class) {
            return value.toString();
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        StringBuilder result = new StringBuilder();
        result.append("class=");
        result.append(value.getClass().getName());
        try {
            String s = value.toString();
            result.append(" toString=");
            result.append(s);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result.toString();
    }
}

