/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import java.security.SecureRandom;

public final class RandomStringGenerator {
    @NotNull
    private final SecureRandom myRandom;
    @NotNull
    private final String myAlphabet;
    @Nullable
    private static RandomStringGenerator ourFromDefaultAlphabet;
    @Nullable
    private static RandomStringGenerator ourFromUpperCaseAlphabet;
    @Nullable
    private static RandomStringGenerator ourFromLowerCaseAlphabet;

    @NotNull
    public String getAlphabet() {
        String string = this.myAlphabet;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static RandomStringGenerator newFromDefaultAlphabet() {
        return new RandomStringGenerator("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    @NotNull
    public static synchronized RandomStringGenerator fromDefaultAlphabet() {
        if (ourFromDefaultAlphabet == null) {
            ourFromDefaultAlphabet = RandomStringGenerator.newFromDefaultAlphabet();
        }
        RandomStringGenerator randomStringGenerator = ourFromDefaultAlphabet;
        if (randomStringGenerator == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return randomStringGenerator;
    }

    @NotNull
    public static String fromDefaultAlphabet(int length) {
        String string = RandomStringGenerator.fromDefaultAlphabet().generateRandomString(length);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static RandomStringGenerator newFromUpperCaseAlphabet() {
        return new RandomStringGenerator("0123456789ABCDEFGHIJKLMNJPQRSTUVWXYZ");
    }

    @NotNull
    public static synchronized RandomStringGenerator fromUpperCaseAlphabet() {
        if (ourFromUpperCaseAlphabet == null) {
            ourFromUpperCaseAlphabet = RandomStringGenerator.newFromUpperCaseAlphabet();
        }
        RandomStringGenerator randomStringGenerator = ourFromUpperCaseAlphabet;
        if (randomStringGenerator == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return randomStringGenerator;
    }

    @NotNull
    public static String fromUpperCaseAlphabet(int length) {
        String string = RandomStringGenerator.fromUpperCaseAlphabet().generateRandomString(length);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static RandomStringGenerator newFromLowerCaseAlphabet() {
        return new RandomStringGenerator("0123456789abcdefghijklmnopqrstuvwxyz");
    }

    @NotNull
    public static synchronized RandomStringGenerator fromLowerCaseAlphabet() {
        if (ourFromLowerCaseAlphabet == null) {
            ourFromLowerCaseAlphabet = RandomStringGenerator.newFromLowerCaseAlphabet();
        }
        RandomStringGenerator randomStringGenerator = ourFromLowerCaseAlphabet;
        if (randomStringGenerator == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return randomStringGenerator;
    }

    @NotNull
    public static String fromLowerCaseAlphabet(int length) {
        String string = RandomStringGenerator.fromLowerCaseAlphabet().generateRandomString(length);
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public RandomStringGenerator(@NotNull String alphabet) {
        if (alphabet == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myRandom = new SecureRandom();
        this.myAlphabet = alphabet;
        this.myRandom.nextInt();
    }

    @NotNull
    public String generateRandomString(int length) {
        int alphabetLength = this.myAlphabet.length();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(this.myAlphabet.charAt(this.myRandom.nextInt(alphabetLength)));
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }
}

