/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.ArrayUtil;
import com.yourkit.util.Strings;
import com.yourkit.util.Util;
import java.util.Arrays;

public class MultiVersion
implements Comparable<MultiVersion> {
    @NotNull
    private final String myOriginalVersionString;
    @NotNull
    private final int[] myParsed;

    public MultiVersion(@NotNull String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myOriginalVersionString = versionString;
        int[] parsed = MultiVersion.parse(versionString);
        this.myParsed = parsed != null ? parsed : ArrayUtil.EMPTY_INT_ARRAY;
    }

    @NotNull
    public String asString() {
        String string = this.myOriginalVersionString;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public int length() {
        return this.myParsed.length;
    }

    @Override
    public int compareTo(@NotNull MultiVersion other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        int[] p1 = this.myParsed;
        int[] p2 = other.myParsed;
        int minLength = Math.min(p1.length, p2.length);
        for (int i = 0; i < minLength; ++i) {
            int v1 = p1[i];
            int v2 = p2[i];
            if (v1 == v2) continue;
            return Util.compare(v1, v2);
        }
        return Util.compare(p1.length, p2.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiVersion version = (MultiVersion)o;
        return Arrays.equals(this.myParsed, version.myParsed);
    }

    public int hashCode() {
        return Arrays.hashCode(this.myParsed);
    }

    @Nullable
    private static int[] parse(@NotNull String versionStr) {
        if (versionStr == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (versionStr.isEmpty()) {
            return null;
        }
        if (versionStr.charAt(versionStr.length() - 1) == '.') {
            return null;
        }
        String[] elements = versionStr.split("\\.");
        int[] result = new int[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            String element = elements[i];
            int integer = Strings.parseInt(element, -1);
            if (integer < 0) {
                return null;
            }
            result[i] = integer;
        }
        return result;
    }

    public int get(int index) {
        return this.myParsed[index];
    }
}

