/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.NotNull;
import com.yourkit.util.Properties;
import com.yourkit.util.Strings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.function.Supplier;

public enum CpuArch {
    UNKNOWN("unknown", false),
    UNKNOWN_32("unknown-32", false),
    UNKNOWN_64("unknown-64", true),
    X86_32("x86-32", false),
    X86_64("x86-64", true),
    ARM_32("arm32", false),
    ARM_64("arm64", true),
    PPC_64("ppc64", true),
    PPC_64LE("ppc64le", true);

    @NotNull
    private static final CpuArch ourCurrentCpuArch;
    @NotNull
    private final String myName;
    private final boolean my64Bit;

    private CpuArch(String name, boolean a64Bit) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myName = name;
        this.my64Bit = a64Bit;
    }

    public boolean is64Bit() {
        return this != UNKNOWN && this.my64Bit;
    }

    public boolean is32Bit() {
        return this != UNKNOWN && !this.my64Bit;
    }

    public boolean isArm() {
        return this == ARM_32 || this == ARM_64;
    }

    public boolean isIntel() {
        return this == X86_32 || this == X86_64;
    }

    @NotNull
    public static CpuArch current() {
        CpuArch cpuArch = ourCurrentCpuArch;
        if (cpuArch == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return cpuArch;
    }

    @NotNull
    public static CpuArch[] allKnown() {
        CpuArch[] cpuArchArray = new CpuArch[]{X86_64, X86_32, ARM_64, ARM_32, PPC_64, PPC_64LE};
        if (cpuArchArray == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return cpuArchArray;
    }

    public boolean isUnknown() {
        return this == UNKNOWN || this == UNKNOWN_32 || this == UNKNOWN_64;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public String toString() {
        return this.getName();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static CpuArch fromName(@NotNull String name) {
        CpuArch cpuArch;
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (CpuArch arch : CpuArch.values()) {
            if (!arch.myName.equals(name)) continue;
            cpuArch = arch;
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        cpuArch = UNKNOWN;
        if (cpuArch != null) return cpuArch;
        throw new IllegalStateException("Method must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static CpuArch fromJavaVersion(@NotNull String output) {
        CpuArch cpuArch;
        if (output == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (output.isEmpty()) {
            cpuArch = UNKNOWN;
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        if (output.contains("amd64") || output.contains("amd64-64") || output.contains("x86_64")) {
            cpuArch = X86_64;
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        if (output.contains("ppc64-64")) {
            cpuArch = PPC_64;
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        cpuArch = output.contains("64-Bit") ? UNKNOWN_64 : UNKNOWN_32;
        if (cpuArch != null) return cpuArch;
        throw new IllegalStateException("Method must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static CpuArch fromJavaVersionWithProperties(@NotNull String output) {
        CpuArch cpuArch;
        if (output == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String prefix = "os.arch = ";
        for (String line : output.split("\n")) {
            if (!(line = line.trim()).startsWith("os.arch = ")) continue;
            cpuArch = CpuArch.fromArchProperty(Strings.cutPrefix(line, "os.arch = "));
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        cpuArch = UNKNOWN;
        if (cpuArch != null) return cpuArch;
        throw new IllegalStateException("Method must not return null");
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static CpuArch fromReleaseFile(@NotNull String javaExePath) {
        block19: {
            block17: {
                block18: {
                    if (javaExePath == null) {
                        throw new IllegalArgumentException("Parameter 1 must not be null");
                    }
                    exePath = Paths.get(javaExePath, new String[0]);
                    binPath = exePath.getParent();
                    if (binPath == null || !Files.isRegularFile(releasePath = binPath.resolveSibling("release"), new LinkOption[0])) break block19;
                    p = new java.util.Properties();
                    stream = Files.newInputStream(releasePath, new OpenOption[0]);
                    var6_7 = null;
                    p.load(stream);
                    value = Strings.notNull(p.getProperty("OS_ARCH"));
                    var8_10 = CpuArch.fromArchProperty(Strings.unquote(value));
                    if (stream == null) break block17;
                    if (var6_7 == null) break block18;
                    try {
                        stream.close();
                    }
                    catch (Throwable var9_11) {
                        var6_7.addSuppressed(var9_11);
                    }
                    break block17;
                }
                stream.close();
            }
            ** if ((v0 = var8_10) != null) goto lbl28
lbl-1000:
            // 2 sources

            {
                throw new IllegalStateException("Method must not return null");
            }
lbl28:
            // 1 sources

            return v0;
            {
                catch (Throwable var7_9) {
                    try {
                        try {
                            var6_7 = var7_9;
                            throw var7_9;
                        }
                        catch (Throwable var10_12) {
                            if (stream != null) {
                                if (var6_7 != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable var11_13) {
                                        var6_7.addSuppressed(var11_13);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                            throw var10_12;
                        }
                    }
                    catch (Exception var5_6) {
                        // empty catch block
                    }
                }
            }
        }
        ** while ((v0 = CpuArch.UNKNOWN) == null)
lbl49:
        // 1 sources

        return v0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static CpuArch fromArchProperty(@NotNull String arch) {
        CpuArch cpuArch;
        if (arch == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (Strings.isNullOrEmpty(arch)) {
            cpuArch = UNKNOWN;
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        if ("x86_64".equals(arch) || "amd64".equals(arch)) {
            cpuArch = X86_64;
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        if ("i386".equals(arch) || "i586".equals(arch) || "x86".equals(arch)) {
            cpuArch = X86_32;
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        if ("ppc64".equals(arch)) {
            cpuArch = PPC_64;
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        if ("ppc64le".equals(arch)) {
            cpuArch = PPC_64LE;
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        if ("arm".equals(arch)) {
            cpuArch = ARM_32;
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        if ("aarch64".equals(arch) || "arm64".equals(arch)) {
            cpuArch = ARM_64;
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        cpuArch = arch.contains("64") ? UNKNOWN_64 : UNKNOWN_32;
        if (cpuArch != null) return cpuArch;
        throw new IllegalStateException("Method must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public CpuArch refine(@NotNull Supplier<CpuArch> supplier) {
        CpuArch cpuArch;
        if (supplier == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (this == UNKNOWN) {
            cpuArch = supplier.get();
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        if (this == UNKNOWN_32 || this == UNKNOWN_64) {
            CpuArch newArch = supplier.get();
            cpuArch = newArch != UNKNOWN ? newArch : this;
            if (cpuArch == null) throw new IllegalStateException("Method must not return null");
            return cpuArch;
        }
        cpuArch = this;
        if (cpuArch != null) return cpuArch;
        throw new IllegalStateException("Method must not return null");
    }

    static {
        ourCurrentCpuArch = CpuArch.fromArchProperty(Properties.os_arch.value(""));
    }
}

