/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.core;

import com.yourkit.asserts.NotNull;
import java.util.List;

public enum GcInfo {
    SERIAL("Serial GC"){

        @Override
        public boolean isKnownCollector(@NotNull List<? extends String> names) {
            if (names == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            return names.contains("Copy") && names.contains("MarkSweepCompact") || names.contains("DefNew") && names.contains("SerialOld");
        }
    }
    ,
    PARALLEL("Parallel GC"){

        @Override
        public boolean isKnownCollector(@NotNull List<? extends String> names) {
            if (names == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            return names.contains("PS Scavenge") && names.contains("PS MarkSweep") || names.contains("ParallelScavenge") && names.contains("ParallelOld");
        }
    }
    ,
    PARALLEL_WITH_SERIAL_OLD("ParallelScavenge + SerialOld"){

        @Override
        public boolean isKnownCollector(@NotNull List<? extends String> names) {
            if (names == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            return names.contains("ParallelScavenge") && names.contains("SerialOld");
        }
    }
    ,
    CMS("CMS"){

        @Override
        public boolean isKnownCollector(@NotNull List<? extends String> names) {
            if (names == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            return names.contains("ParNew") && names.contains("ConcurrentMarkSweep");
        }
    }
    ,
    G1("G1"){

        @Override
        public boolean isKnownCollector(@NotNull List<? extends String> names) {
            if (names == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            return names.stream().anyMatch(name -> name.startsWith("G1"));
        }
    }
    ,
    ZGC("ZGC"){

        @Override
        public boolean isKnownCollector(@NotNull List<? extends String> names) {
            if (names == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            return names.stream().anyMatch(name -> name.startsWith("ZGC") || name.equals("Z"));
        }
    }
    ,
    SHENANDOAH("Shenandoah"){

        @Override
        public boolean isKnownCollector(@NotNull List<? extends String> names) {
            if (names == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            return names.stream().anyMatch(name -> name.startsWith("Shenandoah"));
        }
    };

    @NotNull
    private final String myName;

    private GcInfo(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public abstract boolean isKnownCollector(@NotNull List<? extends String> var1);
}

