/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.perfdata.monitor.MonitorVersionException;

public abstract class AbstractPerfDataBufferPrologue {
    protected ByteBuffer byteBuffer;
    static final int PERFDATA_PROLOG_OFFSET = 0;
    static final int PERFDATA_PROLOG_MAGIC_OFFSET = 0;
    static final int PERFDATA_PROLOG_BYTEORDER_OFFSET = 4;
    static final int PERFDATA_PROLOG_BYTEORDER_SIZE = 1;
    static final int PERFDATA_PROLOG_MAJOR_OFFSET = 5;
    static final int PERFDATA_PROLOG_MAJOR_SIZE = 1;
    static final int PERFDATA_PROLOG_MINOR_OFFSET = 6;
    static final int PERFDATA_PROLOG_MINOR_SIZE = 1;
    static final int PERFDATA_PROLOG_RESERVEDB1_OFFSET = 7;
    static final int PERFDATA_PROLOG_RESERVEDB1_SIZE = 1;
    static final int PERFDATA_PROLOG_SIZE = 8;
    static final byte PERFDATA_BIG_ENDIAN = 0;
    static final byte PERFDATA_LITTLE_ENDIAN = 1;
    static final int PERFDATA_MAGIC = -889274176;
    public static final String PERFDATA_MAJOR_NAME = "sun.perfdata.majorVersion";
    public static final String PERFDATA_MINOR_NAME = "sun.perfdata.minorVersion";

    public AbstractPerfDataBufferPrologue(ByteBuffer byteBuffer) throws MonitorException {
        this.byteBuffer = byteBuffer.duplicate();
        if (this.getMagic() != -889274176) {
            throw new MonitorVersionException("Bad Magic: " + Integer.toHexString(this.getMagic()));
        }
        this.byteBuffer.order(this.getByteOrder());
    }

    public int getMagic() {
        ByteOrder byteOrder = this.byteBuffer.order();
        this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
        this.byteBuffer.position(0);
        int n = this.byteBuffer.getInt();
        this.byteBuffer.order(byteOrder);
        return n;
    }

    public ByteOrder getByteOrder() {
        this.byteBuffer.position(4);
        byte by = this.byteBuffer.get();
        if (by == 0) {
            return ByteOrder.BIG_ENDIAN;
        }
        return ByteOrder.LITTLE_ENDIAN;
    }

    public int getMajorVersion() {
        this.byteBuffer.position(5);
        return this.byteBuffer.get();
    }

    public int getMinorVersion() {
        this.byteBuffer.position(6);
        return this.byteBuffer.get();
    }

    public abstract boolean isAccessible();

    public abstract boolean supportsAccessible();

    public int getSize() {
        return 8;
    }

    public IntBuffer majorVersionBuffer() {
        int[] nArray = new int[]{this.getMajorVersion()};
        IntBuffer intBuffer = IntBuffer.wrap(nArray);
        intBuffer.limit(1);
        return intBuffer;
    }

    public IntBuffer minorVersionBuffer() {
        int[] nArray = new int[]{this.getMinorVersion()};
        IntBuffer intBuffer = IntBuffer.wrap(nArray);
        intBuffer.limit(1);
        return intBuffer;
    }

    public static int getMagic(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        ByteOrder byteOrder = byteBuffer.order();
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.position(0);
        int n2 = byteBuffer.getInt();
        byteBuffer.order(byteOrder);
        byteBuffer.position(n);
        return n2;
    }

    public static int getMajorVersion(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        byteBuffer.position(5);
        byte by = byteBuffer.get();
        byteBuffer.position(n);
        return by;
    }

    public static int getMinorVersion(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        byteBuffer.position(6);
        byte by = byteBuffer.get();
        byteBuffer.position(n);
        return by;
    }

    public static ByteOrder getByteOrder(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        byteBuffer.position(4);
        ByteOrder byteOrder = byteBuffer.get() == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        byteBuffer.position(n);
        return byteOrder;
    }
}

