/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import openj9.internal.tools.attach.target.AttachHandler;
import openj9.internal.tools.attach.target.DiagnosticProperties;
import openj9.internal.tools.attach.target.DiagnosticUtils;
import openj9.internal.tools.attach.target.IPC;
import openj9.tools.attach.diagnostics.attacher.AttacherDiagnosticsProvider;
import openj9.tools.attach.diagnostics.tools.Util;

public class Jstack {
    private static List<String> vmids;
    private static boolean printProperties;
    private static boolean printSynchronizers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        PrintStream printStream = System.out;
        if (!Jstack.parseArguments(stringArray)) {
            System.exit(1);
        }
        AttacherDiagnosticsProvider attacherDiagnosticsProvider = new AttacherDiagnosticsProvider();
        String string = AttachHandler.getVmId();
        printStream.println(LocalDateTime.now());
        for (String string2 : vmids) {
            long l;
            if (string2.equals(string) || string2.matches("\\d+") && !IPC.processExists((long)(l = Long.parseLong(string2)))) continue;
            try {
                attacherDiagnosticsProvider.attach(string2);
                printStream.printf("Virtual machine: %s JVM information:%n", string2);
                Util.runCommandAndPrintResult(attacherDiagnosticsProvider, DiagnosticUtils.makeThreadPrintCommand((boolean)printSynchronizers), "jstack");
                if (!printProperties) continue;
                printStream.println("System properties:");
                Util.printProperties(printStream, attacherDiagnosticsProvider.getSystemProperties());
                printStream.println();
                printStream.println("Agent properties:");
                Util.printProperties(printStream, attacherDiagnosticsProvider.getAgentProperties());
                printStream.println();
            }
            catch (Exception exception) {
                Util.handleCommandException(string2, exception);
            }
            finally {
                try {
                    attacherDiagnosticsProvider.detach();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean parseArguments(String[] stringArray) {
        boolean bl = true;
        printProperties = DiagnosticProperties.isDebug;
        printSynchronizers = false;
        vmids = new ArrayList<String>();
        for (String string : stringArray) {
            if (!string.startsWith("-")) {
                vmids.add(string);
                continue;
            }
            if (string.equals("-p")) {
                printProperties = true;
                continue;
            }
            if (string.equals("-l")) {
                printSynchronizers = true;
                continue;
            }
            System.err.printf("jstack: list thread information about another Java process%n Usage:%n    jstack <vmid>*%n        <vmid>: Attach API VM ID as shown in jps or other Attach API-based tools%n        <vmid>s are read from stdin if none are supplied as arguments%n    -p: print the target's system and agent properties%n    -l: Long format. Print the thread's ownable synchronizers%n    -J: supply arguments to the Java VM running jstack%n", new Object[0]);
            bl = false;
            break;
        }
        if (bl && vmids.isEmpty()) {
            vmids = Util.inStreamToStringList(System.in);
        }
        return bl;
    }
}

