/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.probes;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.probes.ClassNameColumn;
import com.yourkit.probes.ObjectColumn;
import com.yourkit.probes.StringColumn;
import com.yourkit.probes.Table;

public final class ResourceTable<T>
extends Table {
    @Nullable
    private final StringColumn myOptionalName;
    private final ClassNameColumn myClass;
    private final ObjectColumn<T> myObjectID;

    public ResourceTable(@NotNull Class<?> probeClass, String tableName, @Nullable String resourceIdentifierColumnName) {
        if (probeClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        super(probeClass, tableName, 0L);
        this.myClass = new ClassNameColumn("Class");
        this.myObjectID = new ObjectColumn("resource_object_id");
        this.myOptionalName = resourceIdentifierColumnName != null ? new StringColumn(resourceIdentifierColumnName) : null;
    }

    public ResourceTable(@NotNull Table parentTable, @NotNull String tableName, @Nullable String resourceIdentifierColumnName) {
        if (parentTable == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        super(parentTable, tableName, 0L);
        this.myClass = new ClassNameColumn("Class");
        this.myObjectID = new ObjectColumn("resource_object_id");
        this.myOptionalName = resourceIdentifierColumnName != null ? new StringColumn(resourceIdentifierColumnName) : null;
    }

    @Override
    protected boolean acceptNullColumns() {
        return true;
    }

    public void setResourceObject(int row, @NotNull T resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this.myClass.setValue(row, resource.getClass());
        this.myObjectID.setValue(row, resource);
    }

    public boolean hasResourceName() {
        return this.myOptionalName != null;
    }

    public void setResourceName(int row, @Nullable String name) {
        if (this.myOptionalName != null) {
            this.myOptionalName.setValue(row, name);
        }
    }
}

