/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.probes;

import com.yourkit.Constants;
import com.yourkit.asserts.Asserts;
import com.yourkit.asserts.NotNull;
import com.yourkit.probes.ReflectionUtil;
import com.yourkit.runtime.AgentNatives;

public class PidUtil {
    public static int getPid(@NotNull Process process) {
        if (process == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (Constants.JAVA_VERSION_NUMBER >= 9) {
            Long pid = (Long)ReflectionUtil.callMethod0(process, "pid");
            return ((Long)Asserts.requireNotNull((Object)pid)).intValue();
        }
        if (Constants.OS_WINDOWS) {
            long handle = ReflectionUtil.getFieldPrimValue(process, "handle");
            if (handle == 0L) {
                return 0;
            }
            try {
                return AgentNatives.getProcessId((long)handle);
            }
            catch (Throwable throwable) {
            }
        } else {
            try {
                return (int)ReflectionUtil.getFieldPrimValue(process, "pid");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }
}

