/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.probes;

import com.yourkit.asserts.Asserts;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import java.util.WeakHashMap;

public class ClassChecker {
    @NotNull
    private final String[] myClassNames;
    private volatile WeakHashMap<Class<?>, Integer> myClassMaskCache;

    public ClassChecker(String ... classNames) {
        if (classNames == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myClassMaskCache = new WeakHashMap();
        Asserts.requireFalse((classNames.length > 31 ? 1 : 0) != 0, (String)"Too many class names specified - cannot map to int mask");
        this.myClassNames = (String[])Asserts.requireNotEmpty((Object[])classNames);
    }

    public int getMask(@Nullable Object object) {
        if (object == null) {
            return 0;
        }
        return this.getMaskImpl(object.getClass());
    }

    public boolean isAssignableFrom(@NotNull Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return this.getMaskImpl(aClass) != 0;
    }

    public boolean accepts(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return this.getMask(object) != 0;
    }

    public boolean rejects(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return !this.accepts(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaskImpl(@NotNull Class<?> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        Integer cached = this.myClassMaskCache.get(aClass);
        if (cached != null) {
            return cached;
        }
        int mask = 0;
        for (int i = 0; i < this.myClassNames.length; ++i) {
            String className = this.myClassNames[i];
            try {
                Class<?> classForName = Class.forName(className, false, aClass.getClassLoader());
                if (!classForName.isAssignableFrom(aClass)) continue;
                mask |= 1 << i;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ClassChecker classChecker = this;
        synchronized (classChecker) {
            WeakHashMap newMapInstance = new WeakHashMap(this.myClassMaskCache);
            newMapInstance.put(aClass, mask);
            this.myClassMaskCache = newMapInstance;
        }
        return mask;
    }
}

