/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.musl;

import com.yourkit.asserts.Nullable;
import com.yourkit.util.FileUtil;
import com.yourkit.util.Os;
import com.yourkit.util.logging.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public final class MuslUtil {
    @Nullable
    private static Boolean ourMuslCached;

    public static boolean isLinuxMusl() {
        if (ourMuslCached == null) {
            ourMuslCached = MuslUtil.isLinuxMuslImpl();
        }
        return ourMuslCached;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isLinuxMuslImpl() {
        if (!Os.getCurrent().isLinux()) {
            return false;
        }
        try {
            String str = FileUtil.readUtf8(new File("/etc/os-release"));
            if (str.contains("Alpine")) return true;
            if (str.contains("alpine")) {
                return true;
            }
        }
        catch (IOException exc) {
            Logger.error(exc);
        }
        try {
            Process process = Runtime.getRuntime().exec("ldd --version");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String line;
                do {
                    if ((line = reader.readLine()) == null) return false;
                } while (!line.contains("musl libc"));
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exc) {
            Logger.error(exc);
        }
        return false;
    }
}

