/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.io;

import com.yourkit.asserts.NotNull;
import com.yourkit.util.FileUtil;
import com.yourkit.util.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public final class FileDestructor
implements Closeable {
    @NotNull
    private final File myFile;

    public FileDestructor(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myFile = file;
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return file;
    }

    @Override
    public void close() {
        if (!FileUtil.delete(this.myFile)) {
            Logger.warning("Cannot delete; file=" + this.myFile);
        }
    }

    public static FileDestructor createTempDir(@NotNull String prefix) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        return new FileDestructor(FileUtil.createTempDir(prefix));
    }
}

