/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.Constants;
import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.ArrayUtil;
import com.yourkit.util.ObjectRef;
import com.yourkit.util.PresentableException;
import com.yourkit.util.Strings;
import com.yourkit.util.UnexpectedValueException;
import com.yourkit.util.Util;
import com.yourkit.util.musl.MuslUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public final class ProcessHelper {
    private static final boolean CAN_HANG = Constants.IS_IBM || MuslUtil.isLinuxMusl();
    private static final int PROCESS_CREATION_TIMEOUT_SECONDS = 30;
    @NotNull
    private final ProcessBuilder myBuilder;
    @Nullable
    private String myInputStreamEncoding;
    @NotNull
    private OutputReader myOutputReader;
    @Nullable
    private Consumer<String> myOutputLineConsumer;
    @Nullable
    private String myInput;
    private long myTimeLimitSec;
    @NotNull
    private final WeakHashMap<Process, Boolean> myProcessToTimedOut;
    private int myMaxCreateProcessAttempts;

    public ProcessHelper(String ... args) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myOutputReader = this::discardOutput;
        this.myProcessToTimedOut = new WeakHashMap();
        this.myBuilder = new ProcessBuilder(args);
        int maxAttempts = MuslUtil.isLinuxMusl() ? 3 : 1;
        this.setMaxCreateProcessAttempts(maxAttempts);
    }

    public ProcessHelper(@NotNull List<String> args) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this(args.toArray(new String[0]));
    }

    @NotNull
    public static Output killProcess(int pid) {
        ProcessHelper processHelper;
        if (Constants.OS_WINDOWS) {
            processHelper = new ProcessHelper("cmd", "/c", "TaskKill /f /pid " + pid);
            processHelper.encoding(ProcessHelper.getConsoleEncoding());
        } else {
            processHelper = new ProcessHelper("kill", "-9", Integer.toString(pid));
        }
        Output output = processHelper.startAndWaitSafe();
        if (output == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return output;
    }

    public ProcessHelper collectOutput(boolean collect) {
        this.myOutputReader = collect ? this::collectOutput : this::discardOutput;
        return this;
    }

    public ProcessHelper setOutputLineConsumer(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myOutputReader = this::collectOutput;
        this.myOutputLineConsumer = consumer;
        return this;
    }

    public ProcessHelper encoding(@Nullable String inputStreamEncoding) {
        this.myInputStreamEncoding = inputStreamEncoding;
        return this;
    }

    public ProcessHelper directory(@NotNull File workingDirectory) {
        if (workingDirectory == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myBuilder.directory(workingDirectory);
        return this;
    }

    public ProcessHelper setEnvironmentVariable(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        this.myBuilder.environment().put(name, value);
        return this;
    }

    public ProcessHelper setInput(@NotNull String input) {
        if (input == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.myInput = input;
        return this;
    }

    @NotNull
    public Output startAndWait() throws PresentableException {
        Output output;
        this.collectOutput(true);
        try {
            CompletableFuture<Output> future = this.startAsync();
            output = (Output)future.get();
        }
        catch (ExecutionException e) {
            throw new PresentableException("Cannot execute command:\n" + Strings.join("  ", this.myBuilder.command(), "\n", true) + "\nCause: " + e, e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (output == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return output;
    }

    @NotNull
    public Output startAndWaitSafe() {
        Output output;
        try {
            output = this.startAndWait();
        }
        catch (Exception e) {
            return new Output(ArrayUtil.EMPTY_STRING_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, e.toString(), -1);
        }
        if (output == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return output;
    }

    @NotNull
    public CompletableFuture<Output> startAsync() throws PresentableException {
        CompletableFuture<Output> completableFuture = this.startAsync(null);
        if (completableFuture == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Output> startAsync(@Nullable ObjectRef<Process> processRef) throws PresentableException {
        Process process = this.createProcess();
        if (processRef != null) {
            processRef.setRef(process);
        }
        if (this.myTimeLimitSec > 0L) {
            Thread thread = new Thread(() -> {
                try {
                    process.waitFor(this.myTimeLimitSec, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!process.isAlive()) {
                    return;
                }
                this.myProcessToTimedOut.put(process, true);
                process.destroy();
                try {
                    process.waitFor(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (process.isAlive()) {
                    process.destroyForcibly();
                }
            }, "YJP-Watchdog-" + this.info(process));
            thread.setDaemon(true);
            thread.start();
        }
        CompletableFuture<Output> completableFuture = CompletableFuture.supplyAsync(() -> {
            if (this.myInput != null) {
                PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(process.getOutputStream(), Strings.UTF_8), true);
                writer.println(this.myInput);
            }
            return this.readOutput(process);
        });
        if (completableFuture == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return completableFuture;
    }

    public void setMaxCreateProcessAttempts(int attempts) {
        if (attempts <= 0) {
            throw new UnexpectedValueException(attempts);
        }
        this.myMaxCreateProcessAttempts = attempts;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private Process createProcess() throws PresentableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private Future<Process> createProcessAsync() {
        FutureTask<Process> future = new FutureTask<Process>(this.myBuilder::start);
        Thread thread = new Thread(future);
        thread.setDaemon(true);
        thread.start();
        FutureTask<Process> futureTask = future;
        if (futureTask == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return futureTask;
    }

    @NotNull
    private String info(Process process) {
        String string = process.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    private Output readOutput(@NotNull Process process) {
        int exitCode;
        ReaderThread stderrReader;
        ReaderThread stdoutReader;
        block8: {
            if (process == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            stdoutReader = new ReaderThread(process.getInputStream(), "YJP-ReaderThread-stdout");
            stderrReader = new ReaderThread(process.getErrorStream(), "YJP-ReaderThread-stderr");
            stdoutReader.start();
            stderrReader.start();
            exitCode = 0;
            if (CAN_HANG) {
                while (true) {
                    try {
                        exitCode = process.exitValue();
                        break block8;
                    }
                    catch (Exception exception) {
                        Util.sleep(500L);
                        continue;
                    }
                    break;
                }
            }
            try {
                exitCode = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        stdoutReader.ensureFinished();
        stderrReader.ensureFinished();
        if (Boolean.TRUE.equals(this.myProcessToTimedOut.get(process))) {
            stderrReader.myOutput.add("");
            stderrReader.myOutput.add("*** ProcessHelper killed the process by timeout ***");
        }
        return new Output(ArrayUtil.toArray(stdoutReader.myOutput), ArrayUtil.toArray(stderrReader.myOutput), null, exitCode);
    }

    public void setTimeLimit(long seconds) {
        this.myTimeLimitSec = seconds;
    }

    private void discardOutput(@NotNull InputStream is, @NotNull List<String> output) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        try (BufferedInputStream stream = new BufferedInputStream(is);){
            while (stream.read() != -1) {
            }
        }
    }

    private void collectOutput(@NotNull InputStream is, @NotNull List<String> output) throws IOException {
        if (is == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (output == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        String encoding = Strings.notNull(this.myInputStreamEncoding, Strings.UTF_8.name());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));){
            String line;
            while ((line = reader.readLine()) != null) {
                output.add(line);
                if (this.myOutputLineConsumer == null) continue;
                this.myOutputLineConsumer.accept(line);
            }
        }
    }

    @Nullable
    public static String getConsoleEncoding() {
        try {
            Method encoding = Console.class.getDeclaredMethod("encoding", new Class[0]);
            encoding.setAccessible(true);
            return (String)encoding.invoke(null, new Object[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static interface OutputReader {
        public void read(@NotNull InputStream var1, @NotNull List<String> var2) throws IOException;
    }

    private final class ReaderThread
    extends Thread {
        @Nullable
        private final InputStream myStream;
        @NotNull
        private final ArrayList<String> myOutput;

        public ReaderThread(@NotNull InputStream stream, String threadName) {
            if (threadName == null) {
                throw new IllegalArgumentException("Parameter 2 must not be null");
            }
            super(threadName);
            this.myOutput = new ArrayList();
            this.myStream = stream;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (this.myStream == null) {
                return;
            }
            try {
                ProcessHelper.this.myOutputReader.read(this.myStream, this.myOutput);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void ensureFinished() {
            try {
                if (CAN_HANG) {
                    this.join(1000L);
                    this.interrupt();
                } else {
                    this.join();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final class Output {
        @NotNull
        public final String[] myOut;
        @NotNull
        public final String[] myErr;
        @Nullable
        public final String myExplicitError;
        public final int myExitCode;

        public Output(@NotNull String[] out, @NotNull String[] err, @Nullable String explicitError, int exitCode) {
            if (out == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            if (err == null) {
                throw new IllegalArgumentException("Parameter 2 must not be null");
            }
            this.myOut = out;
            this.myErr = err;
            this.myExplicitError = explicitError;
            this.myExitCode = exitCode;
        }

        @NotNull
        public String asString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  exit code: ");
            stringBuilder.append(this.myExitCode);
            stringBuilder.append('\n');
            if (this.myExplicitError != null) {
                stringBuilder.append("  error: ");
                stringBuilder.append(this.myExplicitError);
                stringBuilder.append('\n');
            }
            if (this.myOut.length != 0) {
                stringBuilder.append("  stdout:\n");
                stringBuilder.append(Strings.join("   |", this.myOut, "\n", true));
            }
            if (this.myErr.length != 0) {
                stringBuilder.append("  stderr:\n");
                stringBuilder.append(Strings.join("   |", this.myErr, "\n", true));
            }
            String string = stringBuilder.toString();
            if (string == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return string;
        }

        @NotNull
        public String getFullOutput() {
            String string = Strings.join(this.myOut) + Strings.join(this.myErr);
            if (string == null) {
                throw new IllegalStateException("Method must not return null");
            }
            return string;
        }
    }
}

