/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.NotNull;
import com.yourkit.util.FileUtil;
import com.yourkit.util.Strings;
import com.yourkit.util.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public final class IoUtil {
    public static void readByLine(@NotNull InputStream stream, @NotNull Charset charset, @NotNull LineIterator iterator) throws IOException {
        boolean ok;
        String line;
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
        int lineNumber = 1;
        while ((line = reader.readLine()) != null && (ok = iterator.readLine(line, lineNumber))) {
            ++lineNumber;
        }
    }

    public static void readByLine(@NotNull InputStream stream, @NotNull LineIterator iterator) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        IoUtil.readByLine(stream, Strings.UTF_8, iterator);
    }

    public static void readByLine(@NotNull File file, @NotNull LineIterator iterator) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (iterator == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            IoUtil.readByLine(stream, iterator);
        }
    }

    public static void appendlnUtf8(@NotNull File file, @NotNull String str) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        FileUtil.writeUtf8(file, str, 7);
    }

    public static void writeUtf8(@NotNull File file, @NotNull String str) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        FileUtil.writeUtf8(file, str, 1);
    }

    public static boolean writeUtf8Safe(@NotNull File file, @NotNull String str) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (str == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        try {
            IoUtil.writeUtf8(file, str);
            return true;
        }
        catch (IOException exc) {
            Logger.error("Cannot write file " + file, exc);
            return false;
        }
    }

    public static abstract class AllLineIterator
    implements LineIterator {
        protected abstract void readLineImpl(@NotNull String var1, int var2);

        @Override
        public boolean readLine(@NotNull String line, int lineNumber) {
            if (line == null) {
                throw new IllegalArgumentException("Parameter 1 must not be null");
            }
            this.readLineImpl(line, lineNumber);
            return true;
        }
    }

    public static interface LineIterator {
        public boolean readLine(@NotNull String var1, int var2);
    }
}

