/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util;

import com.yourkit.asserts.NotNull;
import java.util.zip.CRC32;

public class Crc32 {
    @NotNull
    private final CRC32 myCrc = new CRC32();

    public int getValue() {
        return (int)this.myCrc.getValue();
    }

    public void reset() {
        this.myCrc.reset();
    }

    public void update(@NotNull byte[] buf) {
        if (buf == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.update(buf, buf.length);
    }

    public void update(@NotNull byte[] buf, int count) {
        if (buf == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        this.update(buf, 0, count);
    }

    public void update(@NotNull byte[] buf, int start, int end) {
        if (buf == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (start == end) {
            return;
        }
        this.myCrc.update(buf, start, end - start);
    }

    public void updateInt(int value) {
        this.myCrc.update(0xFF & value);
        this.myCrc.update(0xFF & value >> 8);
        this.myCrc.update(0xFF & value >> 16);
        this.myCrc.update(0xFF & value >> 24);
    }
}

