/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.asserts;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.Objects;

public final class Asserts {
    private static boolean ourHeadless = true;

    private Asserts() {
    }

    @NotNull
    public static <T> T[] requireNotNullElements(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException("array contains null at " + i + "; length=" + array.length);
        }
        if (array == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return array;
    }

    public static void fail() {
        throw new IllegalStateException("assertion failed");
    }

    public static void requireZero(int v) {
        if (v != 0) {
            throw new IllegalArgumentException("v=" + v);
        }
    }

    public static void requireZero(int v, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (v != 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void requireZero(long v) {
        if (v != 0L) {
            throw new IllegalArgumentException("v=" + v);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void requireZero(long v, @NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (v != 0L) {
            void message;
            throw new IllegalArgumentException((String)message);
        }
    }

    public static int requireNotZero(int v) {
        if (v == 0) {
            throw new IllegalArgumentException();
        }
        return v;
    }

    public static long requireNotZero(long v) {
        if (v == 0L) {
            throw new IllegalArgumentException();
        }
        return v;
    }

    public static int requireNotNegative(int v) {
        if (v < 0) {
            throw new IllegalArgumentException("v=" + v);
        }
        return v;
    }

    public static long requireNotNegative(long v) {
        if (v < 0L) {
            throw new IllegalArgumentException("v=" + v);
        }
        return v;
    }

    public static int requirePositive(int v) {
        if (v <= 0) {
            throw new IllegalArgumentException("v=" + v);
        }
        return v;
    }

    public static long requirePositive(long v) {
        if (v <= 0L) {
            throw new IllegalArgumentException("v=" + v);
        }
        return v;
    }

    /*
     * WARNING - void declaration
     */
    public static long requirePositive(long v, @NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (v <= 0L) {
            void message;
            throw new IllegalArgumentException((String)message);
        }
        return v;
    }

    public static void requireEqual(int a, int b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void requireEqual(int a, int b, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        if (a != b) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void requireEqual(long a, long b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void requireEqual(boolean a, boolean b) {
        if (a != b) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void requireEqual(@Nullable Enum<?> a, @Nullable Enum<?> b) {
        if (!Objects.equals(a, b)) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    public static void requireEqual(@Nullable String a, @Nullable String b) {
        if (!Objects.equals(a, b)) {
            throw new IllegalArgumentException("assertion failed: " + a + " != " + b);
        }
    }

    @NotNull
    public static String requireNotEmpty(@Nullable String s) {
        if (Asserts.requireNotNull(s).isEmpty()) {
            throw new IllegalArgumentException();
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static String requireNotEmpty(@Nullable String s, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (Asserts.requireNotNull(s).isEmpty()) {
            throw new IllegalArgumentException(message);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public static <X, Y extends Collection<X>> Y requireNotEmpty(@Nullable Y a) {
        if (Asserts.requireNotNull(a).isEmpty()) {
            throw new IllegalArgumentException();
        }
        Y y = a;
        if (y == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return y;
    }

    @NotNull
    public static <T> T[] requireNotEmpty(@Nullable T[] a) {
        if (Asserts.requireNotNull(a).length == 0) {
            throw new IllegalArgumentException();
        }
        if (a == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return a;
    }

    @NotNull
    public static long[] requireNotEmpty(@Nullable long[] a) {
        if (Asserts.requireNotNull(a).length == 0) {
            throw new IllegalArgumentException();
        }
        if (a == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return a;
    }

    @NotNull
    public static int[] requireNotEmpty(@Nullable int[] a) {
        if (Asserts.requireNotNull(a).length == 0) {
            throw new IllegalArgumentException();
        }
        if (a == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return a;
    }

    @NotNull
    public static <T> T[] requireEmpty(@NotNull T[] a) {
        if (a == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (a.length != 0) {
            throw new IllegalArgumentException("assertion failed: array is not empty");
        }
        if (a == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return a;
    }

    public static void requireEmpty(@NotNull Collection<?> a) {
        if (a == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (!a.isEmpty()) {
            throw new IllegalArgumentException("assertion failed: " + a + " is not empty");
        }
    }

    public static void requireFalse(boolean b) {
        if (b) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireFalse(boolean b, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (b) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void requireTrue(boolean b) {
        if (!b) {
            throw new IllegalArgumentException();
        }
    }

    public static void requireTrue(boolean b, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (!b) {
            throw new IllegalArgumentException(message);
        }
    }

    @NotNull
    public static <T> T requireInstanceOf(@Nullable Object obj, @NotNull Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException("assertion failed: " + obj + " is not an instance of " + type);
        }
        T t = type.cast(obj);
        if (t == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return t;
    }

    @NotNull
    public static <T> T requireNotNull(@Nullable T obj) {
        if (obj == null) {
            throw new IllegalArgumentException("assertion failed: null");
        }
        T t = obj;
        if (t == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return t;
    }

    @NotNull
    public static <T> T requireNotNull(@Nullable T obj, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
        T t = obj;
        if (t == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return t;
    }

    @NotNull
    public static <T> T requireNotNullElse(@Nullable T obj, @Nullable T defaultObj) {
        T t = obj != null ? obj : Asserts.requireNotNull(defaultObj, "defaultObj");
        if (t == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return t;
    }

    public static void requireNull(@Nullable Object o) {
        if (o != null) {
            throw new IllegalArgumentException("assertion failed; " + o);
        }
    }

    public static void requireNull(@Nullable Object o, @NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 2 must not be null");
        }
        if (o != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void requireEdt() {
        if (!ourHeadless && !EventQueue.isDispatchThread()) {
            Asserts.fail();
        }
    }

    public static void requireNotEdt() {
        if (!ourHeadless && EventQueue.isDispatchThread()) {
            Asserts.fail();
        }
    }

    public static boolean isHeadless() {
        return ourHeadless;
    }

    public static void setHeadless(boolean headless) {
        ourHeadless = headless;
    }
}

