/*
 * Decompiled with CFR 0.152.
 */
package openj9.tools.attach.diagnostics.tools;

import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import openj9.internal.tools.attach.target.DiagnosticUtils;
import openj9.tools.attach.diagnostics.attacher.AttacherDiagnosticsProvider;
import openj9.tools.attach.diagnostics.tools.Util;

public class Jcmd {
    private static final String HELPTEXT = "Usage : jcmd <vmid> <arguments>%n%n   -J : supply arguments to the Java VM running jcmd%n   -l : list JVM processes on the local machine%n   -h : print this help message%n%n   <vmid> : Attach API VM ID as shown in jps or other Attach API-based tools%n%n   arguments:%n      help : print the list of diagnostic commands%n      help <command> : print help for the specific command%n      <command> [command arguments] : command from the list returned by \"help\"%n%nlist JVM processes on the local machine. Default behavior when no options are specified.%n%nNOTE: this utility might significantly affect the performance of the target JVM.%n    The available diagnostic commands are determined by%n    the target VM and may vary between VMs.%n";
    private static final String[] HELP_OPTIONS = new String[]{"-h", "help", "-help", "--help"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) {
        String string;
        String string2 = null;
        String string3 = string = 0 == stringArray.length ? "-l" : stringArray[0];
        if ("-l".equals(string)) {
            List<AttachProvider> list = AttachProvider.providers();
            AttachProvider attachProvider = null;
            if (!list.isEmpty()) {
                attachProvider = list.get(0);
            }
            if (null == attachProvider) {
                System.err.println("no attach providers available");
                return;
            } else {
                for (VirtualMachineDescriptor virtualMachineDescriptor : attachProvider.listVirtualMachines()) {
                    StringBuilder stringBuilder = new StringBuilder(virtualMachineDescriptor.id());
                    Util.getTargetInformation(attachProvider, virtualMachineDescriptor, false, false, true, stringBuilder);
                    System.out.println(stringBuilder.toString());
                }
            }
            return;
        }
        if (stringArray.length == 1 && null != string) {
            if (Arrays.stream(HELP_OPTIONS).anyMatch(string::equals)) {
                System.out.printf(HELPTEXT, new Object[0]);
                return;
            }
        }
        if ((string2 = DiagnosticUtils.makeJcmdCommand((String[])stringArray, (int)1)).isEmpty()) {
            System.err.printf("There is no jcmd command.%n", new Object[0]);
            System.out.printf(HELPTEXT, new Object[0]);
            return;
        }
        String string4 = string;
        AttacherDiagnosticsProvider attacherDiagnosticsProvider = new AttacherDiagnosticsProvider();
        try {
            attacherDiagnosticsProvider.attach(string4);
            try {
                Util.runCommandAndPrintResult(attacherDiagnosticsProvider, string2, string2);
                return;
            }
            finally {
                attacherDiagnosticsProvider.detach();
            }
        }
        catch (IOException iOException) {
            Util.handleCommandException(string4, iOException);
            System.out.printf(HELPTEXT, new Object[0]);
        }
    }
}

