/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tools.attach.attacher;

import com.sun.tools.attach.VirtualMachineDescriptor;
import com.sun.tools.attach.spi.AttachProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import openj9.internal.tools.attach.target.Advertisement;
import openj9.internal.tools.attach.target.IPC;
import openj9.internal.tools.attach.target.TargetDirectory;

final class OpenJ9VirtualMachineDescriptor
extends VirtualMachineDescriptor {
    private final String replyFile;
    private final String attachSyncFileValue;
    private final long processId;
    private final long uid;
    private final boolean globalSemaphore;

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    OpenJ9VirtualMachineDescriptor(AttachProvider attachProvider, String string, String string2) {
        super(attachProvider, string, string2);
        this.attachSyncFileValue = null;
        this.replyFile = null;
        this.processId = 0L;
        this.uid = 0L;
        this.globalSemaphore = true;
    }

    OpenJ9VirtualMachineDescriptor(AttachProvider attachProvider, String string) {
        super(attachProvider, string);
        this.attachSyncFileValue = null;
        this.replyFile = null;
        this.processId = 0L;
        this.uid = 0L;
        this.globalSemaphore = true;
    }

    OpenJ9VirtualMachineDescriptor(AttachProvider attachProvider, Advertisement advertisement) {
        super(attachProvider, advertisement.getVmId(), advertisement.getDisplayName());
        this.replyFile = advertisement.getReplyFile();
        this.attachSyncFileValue = advertisement.getNotificationSync();
        this.processId = advertisement.getProcessId();
        this.uid = advertisement.getUid();
        this.globalSemaphore = advertisement.isGlobalSemaphore();
    }

    long getProcessId() {
        return this.processId;
    }

    public boolean isGlobalSemaphore() {
        return this.globalSemaphore;
    }

    static OpenJ9VirtualMachineDescriptor fromAdvertisement(AttachProvider attachProvider, File file) {
        Object object;
        Advertisement advertisement = null;
        try {
            object = new FileInputStream(file);
            Throwable throwable = null;
            try {
                advertisement = Advertisement.readAdvertisementFile((InputStream)object);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((FileInputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((FileInputStream)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            IPC.logMessage((String)"could not read advertisement file ", (String)file.getAbsolutePath());
            return null;
        }
        object = new OpenJ9VirtualMachineDescriptor(attachProvider, advertisement);
        return object;
    }

    String getReplyFile() {
        return this.replyFile;
    }

    String getAttachSyncFileValue() {
        String string = this.attachSyncFileValue;
        if (null == string) {
            string = TargetDirectory.createSyncFileObject((String)this.id()).getAbsolutePath();
        }
        return string;
    }

    long getUid() {
        return this.uid;
    }
}

