/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.logging;

import com.yourkit.asserts.NotNull;
import com.yourkit.util.Properties;
import com.yourkit.util.logging.LogLevel;
import com.yourkit.util.logging.LogUtil;
import com.yourkit.util.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ProductLogUtil {
    @NotNull
    public static List<? extends String> getSystemInfo() {
        List<String> list = Arrays.asList("Product: YourKit Java Profiler 2025.9-b171 - built on November 23, 2025", "Date:" + LogUtil.formatTimestamp(new Date()), "JDK: " + Properties.java_version, "OS arch: " + Properties.os_arch, "OS version: " + Properties.os_version, "OS: " + Properties.os_name, "VM version: " + Properties.java_vm_version, "VM: " + Properties.java_vm_name, "Vendor: " + Properties.java_vendor);
        if (list == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return list;
    }

    public static void logHeader() {
        Logger logger = Logger.getLogger();
        logger.log(LogLevel.MESSAGE, "System info:", null);
        logger.log(LogLevel.MESSAGE, "--------------------------------------------------", null);
        for (String string : ProductLogUtil.getSystemInfo()) {
            logger.log(LogLevel.MESSAGE, string, null);
        }
        logger.log(LogLevel.MESSAGE, "System properties:", null);
        logger.log(LogLevel.MESSAGE, "--------------------------------------------------", null);
        for (String string : ProductLogUtil.getSystemProperties()) {
            logger.log(LogLevel.MESSAGE, string, null);
        }
        if (logger.isVerbose()) {
            logger.log(LogLevel.MESSAGE, "Environment:", null);
            logger.log(LogLevel.MESSAGE, "--------------------------------------------------", null);
            for (String string : ProductLogUtil.getEnvironment()) {
                logger.log(LogLevel.MESSAGE, string, null);
            }
        }
    }

    @NotNull
    private static List<? extends String> getEnvironment() {
        Map<String, String> env = System.getenv();
        ArrayList<String> keys = new ArrayList<String>(env.keySet());
        Collections.sort(keys);
        ArrayList<String> lines = new ArrayList<String>(keys.size());
        for (String key : keys) {
            lines.add(key + "=" + env.get(key));
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return arrayList;
    }

    @NotNull
    private static List<? extends String> getSystemProperties() {
        ArrayList<String> keys = new ArrayList<String>();
        java.util.Properties props = System.getProperties();
        for (Object _key : props.keySet()) {
            if (!(_key instanceof String)) continue;
            keys.add((String)_key);
        }
        Collections.sort(keys);
        ArrayList<String> lines = new ArrayList<String>(keys.size());
        for (String key : keys) {
            lines.add(key + "=" + props.get(key));
        }
        ArrayList<String> arrayList = lines;
        if (arrayList == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return arrayList;
    }
}

