/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.http;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.Properties;
import com.yourkit.util.Strings;

public final class UserAgentBuilder {
    @NotNull
    private static final char[] SEPARATORS = new char[]{'(', ')', '<', '>', '@', ',', ';', ':', '\\', '\"', '/', '[', ']', '?', '=', '{', '}', ' ', '\t', '\n', '\r'};
    @Nullable
    private String myProduct;
    @Nullable
    private String myVersion;
    @Nullable
    private String myOs;

    @NotNull
    public UserAgentBuilder product(@Nullable String product) {
        this.myProduct = product;
        UserAgentBuilder userAgentBuilder = this;
        if (userAgentBuilder == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return userAgentBuilder;
    }

    @NotNull
    public UserAgentBuilder version(@Nullable String version) {
        this.myVersion = version;
        UserAgentBuilder userAgentBuilder = this;
        if (userAgentBuilder == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return userAgentBuilder;
    }

    @NotNull
    public UserAgentBuilder os() {
        this.myOs = Properties.os_name + " " + Properties.os_arch + " " + Properties.os_version;
        UserAgentBuilder userAgentBuilder = this;
        if (userAgentBuilder == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return userAgentBuilder;
    }

    @NotNull
    private static String escapeSeparators(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        String result = str;
        for (char separator : SEPARATORS) {
            result = result.replace(separator, '-');
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    @NotNull
    public String asString() {
        StringBuilder b = new StringBuilder();
        if (!Strings.isNullOrEmpty(this.myProduct)) {
            b.append(UserAgentBuilder.escapeSeparators(this.myProduct));
        }
        if (!Strings.isNullOrEmpty(this.myVersion)) {
            Strings.appendSeparated(b, (CharSequence)UserAgentBuilder.escapeSeparators(this.myVersion), "/");
        }
        if (!Strings.isNullOrEmpty(this.myOs)) {
            Strings.appendSeparated(b, (CharSequence)("(" + this.myOs + ")"), " ");
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }
}

