/*
 * Decompiled with CFR 0.152.
 */
package com.yourkit.util.http;

import com.yourkit.asserts.NotNull;
import com.yourkit.asserts.Nullable;
import com.yourkit.util.Strings;

public enum MediaType {
    APPLICATION_JAVASCRIPT("application/javascript", Strings.UTF_8.name(), DataKind.TEXT),
    APPLICATION_JSON("application/json", Strings.UTF_8.name(), DataKind.TEXT),
    APPLICATION_GZIP("application/gzip", null, DataKind.BINARY),
    APPLICATION_OCTET_STREAM("application/octet-stream", null, DataKind.BINARY),
    APPLICATION_PDF("application/pdf", null, DataKind.BINARY),
    APPLICATION_X_PROTOBUF("application/x-protobuf", null, DataKind.BINARY),
    APPLICATION_X_WWW_FORM_URLENCODED("application/x-www-form-urlencoded", null, DataKind.TEXT),
    APPLICATION_XML("application/xml", Strings.UTF_8.name(), DataKind.TEXT),
    FONT_WOFF2("font/woff2", null, DataKind.BINARY),
    IMAGE_X_ICON("image/x-icon", null, DataKind.BINARY),
    SVG_XML("image/svg+xml", null, DataKind.TEXT),
    TEXT_CSS("text/css", Strings.UTF_8.name(), DataKind.TEXT),
    TEXT_HTML("text/html", Strings.UTF_8.name(), DataKind.TEXT),
    TEXT_PLAIN("text/plain", Strings.UTF_8.name(), DataKind.TEXT);

    @NotNull
    public final String type;
    @Nullable
    public final String encoding;
    @NotNull
    public final DataKind dataKind;

    private MediaType(@NotNull String type, String encoding, DataKind dataKind) {
        if (type == null) {
            throw new IllegalArgumentException("Parameter 1 must not be null");
        }
        if (dataKind == null) {
            throw new IllegalArgumentException("Parameter 3 must not be null");
        }
        this.type = type;
        this.encoding = encoding;
        this.dataKind = dataKind;
    }

    @NotNull
    public final String getContentTypeAndEncoding() {
        StringBuilder b = new StringBuilder(this.type);
        if (this.encoding != null) {
            b.append(";").append("charset=").append(this.encoding);
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException("Method must not return null");
        }
        return string;
    }

    public static enum DataKind {
        BINARY,
        TEXT;

    }
}

